/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.generation;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.config.ConfigManager;
import com.HiWord9.RPRenames.util.config.Rename;
import com.HiWord9.RPRenames.util.config.generation.CEMList;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class CEMConfig {
    public static final String DEFAULT_MOB_ITEM = "name_tag";
    private static final String CEM_PATH = "optifine/cem";
    private static final String RANDOM_ENTITY_PATH = "optifine/random/entity/";
    private static final String PROP_EXTENSION = ".properties";

    public static void parseCEMs(class_3300 resourceManager, class_3695 profiler) {
        profiler.method_15396("rprenames:collecting_cem_renames");
        ArrayList<String> checked = new ArrayList<String>();
        for (Map.Entry entry : resourceManager.method_14488(CEM_PATH, s -> {
            String path = s.method_12832();
            if (!path.endsWith(".jem")) {
                return false;
            }
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            return Arrays.stream(CEMList.models).toList().contains(fileName.substring(0, fileName.length() - 4));
        }).entrySet()) {
            try {
                for (String jpmFileName : CEMConfig.objToParamList(CEMConfig.objFromInputStream(((class_3298)entry.getValue()).method_14482()), "model")) {
                    String textureName;
                    class_2960 propId;
                    Optional optionalResourceProp;
                    class_3298 resourceJpm;
                    ArrayList<String> textures;
                    Optional optionalResourceJpm;
                    if (jpmFileName == null || !jpmFileName.endsWith(".jpm") || (optionalResourceJpm = resourceManager.method_14486(new class_2960("minecraft", "optifine/cem/" + jpmFileName))).isEmpty() || (textures = CEMConfig.objToParamList(CEMConfig.objFromInputStream((resourceJpm = (class_3298)optionalResourceJpm.get()).method_14482()), "texture")).isEmpty() || (optionalResourceProp = resourceManager.method_14486(propId = new class_2960("minecraft", RANDOM_ENTITY_PATH + (textureName = CEMConfig.getPropPathInRandom(textures.get(0))) + PROP_EXTENSION))).isEmpty()) continue;
                    class_3298 resourceProp = (class_3298)optionalResourceProp.get();
                    String packName = ConfigManager.validatePackName(resourceProp.method_14480());
                    String path = ConfigManager.getFullPathFromIdentifier(packName, propId);
                    checked.add(path);
                    String keyPath = ((class_2960)entry.getKey()).method_12832();
                    String fileName = keyPath.substring(keyPath.lastIndexOf("/") + 1, keyPath.length() - 4);
                    int i = Arrays.stream(CEMList.models).toList().indexOf(fileName);
                    if (i < 0) continue;
                    CEMConfig.propertiesToRenameMob(ConfigManager.getPropFromResource(resourceProp), packName, path, CEMList.mobs[i].method_35050());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int c = 0; c < CEMList.textures.length; ++c) {
            try {
                class_3298 resource;
                String packName;
                String path;
                class_2960 identifier = new class_2960("minecraft", RANDOM_ENTITY_PATH + CEMList.textures[c] + PROP_EXTENSION);
                Optional optionalResource = resourceManager.method_14486(identifier);
                if (optionalResource.isEmpty() && (optionalResource = resourceManager.method_14486(identifier = new class_2960("minecraft", RANDOM_ENTITY_PATH + CEMConfig.getLastPathPart(CEMList.textures[c]) + PROP_EXTENSION))).isEmpty() || checked.contains(path = ConfigManager.getFullPathFromIdentifier(packName = ConfigManager.validatePackName((resource = (class_3298)optionalResource.get()).method_14480()), identifier))) continue;
                CEMConfig.propertiesToRenameMob(ConfigManager.getPropFromResource(resource), packName, path, CEMList.mobs[c].method_35050());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        profiler.method_15407();
    }

    private static Object objFromInputStream(InputStream inputStream) {
        Object obj = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            Type type = new TypeToken<Object>(){}.getType();
            Gson gson = new Gson();
            obj = gson.fromJson((Reader)bufferedReader, type);
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private static ArrayList<String> objToParamList(Object obj, String param) {
        String string = obj.toString();
        ArrayList<String> list = new ArrayList<String>();
        int j = string.length() - param.length();
        for (int i = 0; i < j; ++i) {
            if (!string.startsWith(param + "=", i) || i != 0 && String.valueOf(string.charAt(i - 1)).matches("[a-zA-Z]")) continue;
            int start = i + param.length() + 1;
            if (!string.contains(",")) continue;
            list.add(string.substring(start, string.indexOf(44, start)));
        }
        return list;
    }

    private static void propertiesToRenameMob(Properties p, String packName, String path, String fileName) {
        ArrayList<String> skins = new ArrayList<String>();
        for (String s : p.stringPropertyNames()) {
            Rename rename;
            String skin;
            if (!s.startsWith("name.") || skins.contains(skin = p.getProperty("skins." + s.substring(5)))) continue;
            skins.add(skin);
            String name = ConfigManager.getFirstName(p.getProperty(s));
            if (name == null) continue;
            ArrayList<Rename> alreadyExist = ConfigManager.getRenames(DEFAULT_MOB_ITEM);
            Rename renameNameOnly = new Rename(name, DEFAULT_MOB_ITEM);
            Rename.Mob mob = new Rename.Mob(fileName, ConfigManager.getIdAndPath(CEMList.iconFromName(fileName)), p, path.replaceAll("\\\\", "/"));
            if (renameNameOnly.isContainedIn(alreadyExist, true)) {
                Rename renameForItem = alreadyExist.get(renameNameOnly.indexIn(alreadyExist, true));
                alreadyExist.remove(renameNameOnly.indexIn(alreadyExist, true));
                rename = new Rename(renameForItem.getName(), renameForItem.getItems(), renameForItem.getPackName(), renameForItem.getPath(), renameForItem.getStackSize(), renameForItem.getDamage(), renameForItem.getEnchantment(), renameForItem.getEnchantmentLevel(), renameForItem.getProperties(), renameForItem.getDescription(), mob);
            } else {
                rename = new Rename(name, packName, mob);
            }
            if (rename.isContainedIn(alreadyExist)) continue;
            ArrayList<Rename> newConfig = new ArrayList<Rename>(alreadyExist);
            newConfig.add(rename);
            RPRenames.renames.put(DEFAULT_MOB_ITEM, newConfig);
        }
    }

    private static String getLastPathPart(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static String getPropPathInRandom(String texturePath) {
        if (texturePath.endsWith(".png")) {
            texturePath = texturePath.substring(0, texturePath.length() - 4);
        }
        if (texturePath.startsWith("textures/entity/")) {
            texturePath = texturePath.substring(16);
        }
        return texturePath;
    }
}

