/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapperManager;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3532;
import net.minecraft.class_3980;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public class Colormap
implements class_6539,
class_322 {
    private final IColormapNumberProvider xGetter;
    private final IColormapNumberProvider yGetter;
    private final BiomeIdMapper biomeMapper;
    private final boolean triangular;
    private final boolean hasBiomeBlend;
    private final boolean usesBiome;
    private final boolean usesPos;
    private final boolean usesState;
    private Integer defaultColor;
    private ArrayImage image = null;
    private class_2960 targetTexture = null;
    private final ThreadLocal<class_2680> stateHack = new ThreadLocal();
    private final ThreadLocal<Integer> yHack = new ThreadLocal();
    public static final Codec<Colormap> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ColorUtils.CODEC, "default_color").forGetter(c -> Optional.ofNullable(c.defaultColor)), (App)IColormapNumberProvider.CODEC.fieldOf("x_axis").forGetter(c -> c.xGetter), (App)IColormapNumberProvider.CODEC.fieldOf("y_axis").forGetter(c -> c.yGetter), (App)StrOpt.of(Codec.BOOL, "triangular", false).forGetter(c -> c.triangular), (App)StrOpt.of(Codec.BOOL, "biome_blend").forGetter(c -> Optional.of(c.hasBiomeBlend)), (App)StrOpt.of(BiomeIdMapperManager.CODEC, "biome_id_mapper").forGetter(c -> Optional.of(c.biomeMapper))).apply((Applicative)i, Colormap::new));
    protected static final Codec<class_322> REFERENCE_CODEC = class_2960.field_25139.flatXmap(id -> Optional.ofNullable(Polytone.COLORMAPS.get((class_2960)id)).map(DataResult::success).orElse(DataResult.error(() -> "Could not find a custom Colormap with id " + id + " Did you place it in 'assets/[your pack]/polytone/colormaps/' ?")), object -> Optional.ofNullable(Polytone.COLORMAPS.getKey((class_322)object)).map(DataResult::success).orElse(DataResult.error(() -> "Unknown Color Property: " + object)));
    protected static final Codec<class_322> SINGLE_COLOR_CODEC = ColorUtils.CODEC.xmap(Colormap::singleColor, c -> {
        Integer n;
        if (c instanceof Colormap) {
            Colormap cm = (Colormap)c;
            n = cm.defaultColor;
        } else {
            n = 0;
        }
        return n;
    });
    public static final Codec<class_322> CODEC = Codec.either(SINGLE_COLOR_CODEC, new ReferenceOrDirectCodec<Colormap>(REFERENCE_CODEC, DIRECT_CODEC)).xmap(e -> (class_322)e.map(Function.identity(), Function.identity()), Either::left);

    private Colormap(Optional<Integer> defaultColor, IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular, Optional<Boolean> biomeBlend, Optional<BiomeIdMapper> biomeMapper) {
        this.defaultColor = defaultColor.orElse(null);
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.triangular = triangular;
        this.usesBiome = xGetter.usesBiome() || yGetter.usesBiome();
        this.usesPos = this.usesBiome || xGetter.usesPos() || yGetter.usesPos();
        this.usesState = xGetter.usesState() || yGetter.usesState();
        this.hasBiomeBlend = biomeBlend.orElse(this.usesBiome);
        this.biomeMapper = biomeMapper.orElse(BiomeIdMapper.BY_INDEX);
    }

    protected Colormap(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        this(Optional.empty(), xGetter, yGetter, false, Optional.empty(), Optional.empty());
    }

    public static Colormap simple(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        return new Colormap(xGetter, yGetter);
    }

    public static Colormap fixed() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false, Optional.empty(), Optional.empty());
    }

    private static Colormap singleColor(int color) {
        Colormap c = new Colormap(Optional.empty(), IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false, Optional.empty(), Optional.empty());
        c.acceptTexture(new ArrayImage(new int[][]{{color}}));
        return c;
    }

    public static Colormap defSquare() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, false, Optional.empty(), Optional.empty());
    }

    public static Colormap defTriangle() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, true, Optional.empty(), Optional.empty());
    }

    public static Colormap biomeId() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.BIOME_ID, IColormapNumberProvider.Y_LEVEL, false, Optional.of(Boolean.TRUE), Optional.empty());
    }

    public void acceptTexture(ArrayImage image) {
        this.image = image;
        if (this.defaultColor == null) {
            this.defaultColor = this.sample(0.5f, 0.5f, -1);
        }
    }

    public boolean hasTexture() {
        return this.image != null;
    }

    public class_2960 getTargetTexture() {
        return this.targetTexture;
    }

    public void setTargetTexture(class_2960 imageTarget) {
        this.targetTexture = imageTarget.method_45136(imageTarget.method_12832().replace(".png", ""));
    }

    public int getColor(@Nullable class_2680 state, @Nullable class_1920 level, @Nullable class_2338 pos, int i) {
        if (level == null) {
            return this.defaultColor;
        }
        if (pos == null && (this.usesPos || this.usesBiome)) {
            return this.defaultColor;
        }
        if (state == null && this.usesState) {
            return this.defaultColor;
        }
        if (this.hasBiomeBlend) {
            this.stateHack.set(state);
            this.yHack.set(pos != null ? pos.method_10264() : 0);
            return level.method_23752(pos, (class_6539)this);
        }
        return this.sampleColor(state, pos, null);
    }

    private int sampleColor(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome) {
        float temperature = class_3532.method_15363((float)this.xGetter.getValue(state, pos, biome, this.biomeMapper), (float)0.0f, (float)1.0f);
        float humidity = class_3532.method_15363((float)this.yGetter.getValue(state, pos, biome, this.biomeMapper), (float)0.0f, (float)1.0f);
        return this.sample(humidity, temperature, this.defaultColor);
    }

    public int getColor(class_1959 biome, double x, double z) {
        Integer y = this.yHack.get();
        if (y == null) {
            y = 0;
        }
        return this.sampleColor(this.stateHack.get(), class_2338.method_49637((double)x, (double)y.intValue(), (double)z), biome);
    }

    public int calculateBlendedColor(class_1937 level, class_2338 pos) {
        int i = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
        class_2680 state = this.stateHack.get();
        if (i == 0) {
            return this.sampleColor(state, pos, (class_1959)level.method_23753(pos).comp_349());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        class_3980 cursor3D = new class_3980(pos.method_10263() - i, pos.method_10264(), pos.method_10260() - i, pos.method_10263() + i, pos.method_10264(), pos.method_10260() + i);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        while (cursor3D.method_17963()) {
            mutableBlockPos.method_10103(cursor3D.method_18671(), cursor3D.method_18672(), cursor3D.method_18673());
            int n = this.sampleColor(state, (class_2338)mutableBlockPos, (class_1959)level.method_23753((class_2338)mutableBlockPos).comp_349());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    private int sample(float textY, float textX, int defValue) {
        if (this.triangular) {
            textY *= textX;
        }
        int width = this.image.width();
        int height = this.image.height();
        int w = (int)((1.0 - (double)textX) * (double)(width - 1));
        int h = (int)((1.0 - (double)textY) * (double)(height - 1));
        return w >= width || h >= height ? defValue : this.image.pixels()[h][w];
    }
}

