/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;

public final class ReferenceOrDirectCodec<E>
implements Codec<E> {
    private final Codec<E> reference;
    private final Codec<E> direct;
    private final boolean bothStrings;

    public ReferenceOrDirectCodec(Codec<? extends E> reference, Codec<? extends E> direct) {
        this.reference = reference;
        this.direct = direct;
        this.bothStrings = false;
    }

    public ReferenceOrDirectCodec(Codec<? extends E> reference, Codec<? extends E> direct, boolean bothStrings) {
        this.reference = reference;
        this.direct = direct;
        this.bothStrings = bothStrings;
    }

    public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
        DataResult ref;
        if (ops.getStringValue(input).result().isPresent() && ((ref = this.reference.decode(ops, input)).result().isPresent() || !this.bothStrings)) {
            return ref;
        }
        return this.direct.decode(ops, input);
    }

    public <T> DataResult<T> encode(E input, DynamicOps<T> ops, T prefix) {
        DataResult ref;
        if (ops.compressMaps() && (ref = this.reference.encode(input, ops, prefix)).result().isPresent()) {
            return ref;
        }
        return this.direct.encode(input, ops, prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceOrDirectCodec eitherCodec = (ReferenceOrDirectCodec)o;
        return Objects.equals(this.reference, eitherCodec.reference) && Objects.equals(this.direct, eitherCodec.direct);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.direct);
    }

    public String toString() {
        return "ReferenceOrDirect[" + this.reference + ", " + this.direct + "]";
    }
}

