/*
 * Decompiled with CFR 0.152.
 */
package carpet.settings;

import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.Validators;
import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpet.utils.Messenger;
import carpet.utils.Translations;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.apache.commons.lang3.ClassUtils;

@Deprecated(forRemoval=true)
public final class ParsedRule<T>
implements CarpetRule<T>,
Comparable<ParsedRule<?>> {
    private static final Map<Class<?>, FromStringConverter<?>> CONVERTER_MAP = Map.ofEntries(Map.entry(String.class, str -> str), Map.entry(Boolean.class, str -> switch (str) {
        case "true" -> true;
        case "false" -> false;
        default -> throw new InvalidRuleValueException("Invalid boolean value");
    }), ParsedRule.numericalConverter(Integer.class, Integer::parseInt), ParsedRule.numericalConverter(Double.class, Double::parseDouble), ParsedRule.numericalConverter(Long.class, Long::parseLong), ParsedRule.numericalConverter(Float.class, Float::parseFloat));
    @Deprecated(forRemoval=true)
    public final Field field;
    @Deprecated(forRemoval=true)
    public final String name;
    @Deprecated(forRemoval=true)
    public final String description;
    @Deprecated(forRemoval=true)
    public final List<String> extraInfo;
    @Deprecated(forRemoval=true)
    public final List<String> categories;
    @Deprecated(forRemoval=true)
    public final List<String> options;
    @Deprecated(forRemoval=true)
    public boolean isStrict;
    @Deprecated(forRemoval=true)
    public boolean isClient;
    @Deprecated(forRemoval=true)
    public final Class<T> type;
    @Deprecated(forRemoval=true)
    public final T defaultValue;
    @Deprecated(forRemoval=true)
    public final SettingsManager settingsManager;
    @Deprecated(forRemoval=true)
    public final List<Validator<T>> validators;
    @Deprecated(forRemoval=true)
    public final String defaultAsString;
    @Deprecated(forRemoval=true)
    public final String scarpetApp;
    private final FromStringConverter<T> converter;
    private final carpet.api.settings.SettingsManager realSettingsManager;
    @Deprecated(forRemoval=true)
    public final List<carpet.api.settings.Validator<T>> realValidators;
    private final boolean isLegacy;
    private static boolean warnedComparable = false;

    @Deprecated(forRemoval=true)
    public static <T> ParsedRule<T> of(Field field, carpet.api.settings.SettingsManager settingsManager) {
        RuleAnnotation rule;
        if (field.isAnnotationPresent(carpet.api.settings.Rule.class)) {
            carpet.api.settings.Rule a = field.getAnnotation(carpet.api.settings.Rule.class);
            rule = new RuleAnnotation(false, null, null, null, a.categories(), a.options(), a.strict(), a.appSource(), a.validators());
        } else if (settingsManager instanceof SettingsManager && field.isAnnotationPresent(Rule.class)) {
            Rule a = field.getAnnotation(Rule.class);
            rule = new RuleAnnotation(true, a.name(), a.desc(), a.extra(), a.category(), a.options(), a.strict(), a.appSource(), a.validate());
        } else {
            throw new IllegalArgumentException("Old rule annotation is only supported in legacy SettngsManager!");
        }
        return new ParsedRule<T>(field, rule, settingsManager);
    }

    private ParsedRule(Field field, RuleAnnotation rule, carpet.api.settings.SettingsManager settingsManager) {
        Class type;
        this.isLegacy = rule.isLegacy();
        this.name = !this.isLegacy || rule.name().isEmpty() ? field.getName() : rule.name();
        this.field = field;
        this.type = type = ClassUtils.primitiveToWrapper(field.getType());
        this.isStrict = rule.strict();
        this.categories = List.of(rule.category());
        this.scarpetApp = rule.appSource();
        this.realSettingsManager = settingsManager;
        this.settingsManager = !(settingsManager instanceof SettingsManager) ? null : (SettingsManager)settingsManager;
        this.realValidators = Stream.of(rule.validators()).map(this::instantiateValidator).collect(Collectors.toList());
        this.defaultValue = this.value();
        FromStringConverter<Object> converter0 = null;
        if (this.categories.contains("command")) {
            this.realValidators.add(new Validator._COMMAND());
            if (this.type == String.class) {
                this.realValidators.add(this.instantiateValidator(Validators.CommandLevel.class));
            }
        }
        this.isClient = this.categories.contains("client");
        if (this.isClient) {
            this.realValidators.add(new Validator._CLIENT());
        }
        if (!this.scarpetApp.isEmpty()) {
            this.realValidators.add(new Validator.ScarpetValidator());
        }
        if (rule.options().length > 0) {
            this.options = List.of(rule.options());
        } else if (this.type == Boolean.class) {
            this.options = List.of("true", "false");
        } else if (this.type == String.class && this.categories.contains("command")) {
            this.options = Validators.CommandLevel.OPTIONS;
        } else if (this.type.isEnum()) {
            this.options = Arrays.stream(this.type.getEnumConstants()).map(e -> ((Enum)e).name().toLowerCase(Locale.ROOT)).toList();
            converter0 = str -> {
                try {
                    Object ret = Enum.valueOf(type, str.toUpperCase(Locale.ROOT));
                    return ret;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRuleValueException("Valid values for this rule are: " + this.options);
                }
            };
        } else {
            this.options = List.of();
        }
        if (this.isStrict && !this.options.isEmpty()) {
            this.realValidators.add(0, new Validator.StrictValidator());
        }
        if (converter0 == null) {
            FromStringConverter<?> converterFromMap = CONVERTER_MAP.get(type);
            if (converterFromMap == null) {
                throw new UnsupportedOperationException("Unsupported type for ParsedRule" + type);
            }
            converter0 = converterFromMap;
        }
        this.converter = converter0;
        String nameKey = "%s.rule.%s.name".formatted(this.settingsManager().identifier(), this.name());
        String descKey = "%s.rule.%s.desc".formatted(this.settingsManager().identifier(), this.name());
        String extraPrefix = "%s.rule.%s.extra.".formatted(this.settingsManager().identifier(), this.name());
        this.description = this.isLegacy ? rule.desc() : Objects.requireNonNull(Translations.trOrNull(descKey), "No language key provided for " + descKey);
        this.extraInfo = this.isLegacy ? List.of(rule.extra()) : this.getTranslationArray(extraPrefix);
        this.defaultAsString = RuleHelper.toRuleString(this.defaultValue);
        this.validators = this.realValidators.stream().filter(Validator.class::isInstance).map(v -> (Validator)v).toList();
        if (!this.isLegacy && !this.validators.isEmpty()) {
            throw new IllegalArgumentException("Can't use legacy validators with new rules!");
        }
        if (this.isLegacy && !rule.name().isEmpty()) {
            Translations.registerFallbackTranslation(nameKey, this.name);
        }
        Translations.registerFallbackTranslation(descKey, this.description);
        Iterator<String> infoIterator = this.extraInfo.iterator();
        int i = 0;
        while (infoIterator.hasNext()) {
            Translations.registerFallbackTranslation(extraPrefix + i, infoIterator.next());
            ++i;
        }
    }

    private carpet.api.settings.Validator<T> instantiateValidator(Class<? extends carpet.api.settings.Validator> cls) {
        try {
            Constructor<? extends carpet.api.settings.Validator> constr = cls.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(class_2168 source, String value) throws InvalidRuleValueException {
        this.set(source, this.converter.convert(value), value);
    }

    private void set(class_2168 source, T value, String userInput) throws InvalidRuleValueException {
        for (carpet.api.settings.Validator<T> validator : this.realValidators) {
            value = validator.validate(source, this, value, userInput);
            if (value != null) continue;
            if (source != null) {
                validator.notifyFailure(source, this, userInput);
            }
            throw new InvalidRuleValueException();
        }
        if (!value.equals(this.value()) || source == null) {
            try {
                this.field.set(null, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Couldn't access field for rule: " + this.name, e);
            }
            if (source != null) {
                this.settingsManager().notifyRuleChanged(source, this, userInput);
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ParsedRule && ((ParsedRule)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + ": " + RuleHelper.toRuleString(this.value());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<class_2561> extraInfo() {
        return this.getTranslationArray("%s.rule.%s.extra.".formatted(this.settingsManager().identifier(), this.name())).stream().map(str -> Messenger.c("g " + str)).toList();
    }

    private List<String> getTranslationArray(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (Translations.hasTranslation(prefix + i)) {
            ret.add(Translations.tr(prefix + i));
            ++i;
        }
        return ret;
    }

    @Override
    public Collection<String> categories() {
        return this.categories;
    }

    @Override
    public Collection<String> suggestions() {
        return this.options;
    }

    @Override
    public carpet.api.settings.SettingsManager settingsManager() {
        return this.realSettingsManager;
    }

    @Override
    public T value() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Couldn't access field for rule: " + this.name, e);
        }
    }

    @Override
    public boolean canBeToggledClientSide() {
        return this.isClient;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void set(class_2168 source, T value) throws InvalidRuleValueException {
        this.set(source, value, RuleHelper.toRuleString(value));
    }

    @Override
    public boolean strict() {
        return !this.realValidators.isEmpty() && this.realValidators.get(0) instanceof Validator.StrictValidator;
    }

    private static <T> Map.Entry<Class<T>, FromStringConverter<T>> numericalConverter(Class<T> outputClass, Function<String, T> converter) {
        return Map.entry(outputClass, str -> {
            try {
                return converter.apply(str);
            }
            catch (NumberFormatException e) {
                throw new InvalidRuleValueException("Invalid number for rule");
            }
        });
    }

    @Deprecated(forRemoval=true)
    public T get() {
        return this.value();
    }

    @Deprecated(forRemoval=true)
    public String getAsString() {
        return RuleHelper.toRuleString(this.value());
    }

    @Deprecated(forRemoval=true)
    public boolean getBoolValue() {
        return RuleHelper.getBooleanValue(this);
    }

    @Deprecated(forRemoval=true)
    public boolean isDefault() {
        return RuleHelper.isInDefaultValue(this);
    }

    @Deprecated(forRemoval=true)
    public void resetToDefault(class_2168 source) {
        RuleHelper.resetToDefault(this, source);
    }

    @Override
    @Deprecated(forRemoval=true)
    public int compareTo(ParsedRule<?> o) {
        if (!warnedComparable) {
            warnedComparable = true;
            CarpetSettings.LOG.warn("Extension is relying on carpet rules to be comparable! This is not true for all carpet rules anymore, and will crash the game in future versions or if an extension adds non-comparable rules!\nFixing it is as simple as passing Comparator.comparing(CarpetRule::name) to the sorting method!", new Throwable("Location:").fillInStackTrace());
        }
        return this.name.compareTo(o.name);
    }

    @Deprecated(forRemoval=true)
    public String translatedName() {
        return RuleHelper.translatedName(this);
    }

    @Deprecated(forRemoval=true)
    public String translatedDescription() {
        return RuleHelper.translatedDescription(this);
    }

    @Deprecated(forRemoval=true)
    public List<String> translatedExtras() {
        return this.extraInfo().stream().map(class_2561::getString).toList();
    }

    record RuleAnnotation(boolean isLegacy, String name, String desc, String[] extra, String[] category, String[] options, boolean strict, String appSource, Class<? extends carpet.api.settings.Validator>[] validators) {
    }

    @FunctionalInterface
    static interface FromStringConverter<T> {
        public T convert(String var1) throws InvalidRuleValueException;
    }
}

