/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers;

import dev.isxander.adaptivetooltips.config.AdaptiveTooltipConfig;
import dev.isxander.adaptivetooltips.config.ScrollDirection;
import dev.isxander.adaptivetooltips.mixins.BundleTooltipComponentAccessor;
import dev.isxander.adaptivetooltips.mixins.ClientTextTooltipAccessor;
import dev.isxander.adaptivetooltips.utils.TextUtil;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5682;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public class ScrollTracker {
    private static int targetVerticalScroll = 0;
    private static int targetHorizontalScroll = 0;
    private static float currentVerticalScroll = 0.0f;
    private static float currentHorizontalScroll = 0.0f;
    private static List<class_5684> trackedComponents = null;
    public static boolean renderedThisFrame = false;

    public static void addVerticalScroll(int amt) {
        if (((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).scrollDirection == ScrollDirection.NATURAL) {
            amt = -amt;
        }
        targetVerticalScroll += amt * ((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).verticalScrollSensitivity;
    }

    public static void addHorizontalScroll(int amt) {
        if (((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).scrollDirection == ScrollDirection.NATURAL) {
            amt = -amt;
        }
        targetHorizontalScroll += amt * ((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).horizontalScrollSensitivity;
    }

    public static float getVerticalScroll() {
        return currentVerticalScroll;
    }

    public static float getHorizontalScroll() {
        return currentHorizontalScroll;
    }

    public static void scroll(class_332 graphics, List<class_5684> components, int x, int y, int width, int height, int screenWidth, int screenHeight) {
        ScrollTracker.tick(components, x, y, width, height, screenWidth, screenHeight, class_310.method_1551().method_1534());
        graphics.method_51448().method_46416(ScrollTracker.getHorizontalScroll(), ScrollTracker.getVerticalScroll(), 0.0f);
    }

    private static void tick(List<class_5684> components, int x, int y, int width, int height, int screenWidth, int screenHeight, float tickDelta) {
        renderedThisFrame = true;
        ScrollTracker.resetIfNeeded(components);
        if (height < screenHeight) {
            targetVerticalScroll = 0;
        }
        if (width < screenWidth) {
            targetHorizontalScroll = 0;
        }
        targetVerticalScroll = class_3532.method_15340((int)targetVerticalScroll, (int)Math.min(screenHeight - (y + height) - 4, 0), (int)Math.max(-y + 4, 0));
        targetHorizontalScroll = class_3532.method_15340((int)targetHorizontalScroll, (int)Math.min(screenWidth - (x + width) - 4, 0), (int)Math.max(-x + 4, 0));
        ScrollTracker.tickAnimation(tickDelta);
    }

    private static void tickAnimation(float tickDelta) {
        if (((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).smoothScrolling) {
            currentVerticalScroll = class_3532.method_16439((float)(tickDelta * 0.5f), (float)currentVerticalScroll, (float)targetVerticalScroll);
            currentHorizontalScroll = class_3532.method_16439((float)(tickDelta * 0.5f), (float)currentHorizontalScroll, (float)targetHorizontalScroll);
        } else {
            currentVerticalScroll = targetVerticalScroll;
            currentHorizontalScroll = targetHorizontalScroll;
        }
    }

    private static void resetIfNeeded(List<class_5684> components) {
        if (!ScrollTracker.isEqual(components, trackedComponents)) {
            ScrollTracker.reset();
        }
        trackedComponents = components;
    }

    public static void reset() {
        targetHorizontalScroll = 0;
        targetVerticalScroll = 0;
        currentHorizontalScroll = 0.0f;
        currentVerticalScroll = 0.0f;
    }

    private static boolean isEqual(List<class_5684> l1, List<class_5684> l2) {
        if (l1 == null || l2 == null) {
            return false;
        }
        Iterator<class_5684> iter1 = l1.iterator();
        Iterator<class_5684> iter2 = l2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            class_5684 c2;
            class_5684 c1 = iter1.next();
            if (c1 == (c2 = iter2.next())) continue;
            if (c1 instanceof class_5683) {
                class_5683 ot1 = (class_5683)c1;
                if (c2 instanceof class_5683) {
                    class_5683 ot2 = (class_5683)c2;
                    if (TextUtil.toText(((ClientTextTooltipAccessor)ot1).getText()).equals((Object)TextUtil.toText(((ClientTextTooltipAccessor)ot2).getText()))) continue;
                    return false;
                }
            }
            if (c1 instanceof class_5682) {
                class_5682 bt1 = (class_5682)c1;
                if (c2 instanceof class_5682) {
                    class_5682 bt2 = (class_5682)c2;
                    Iterator i1 = ((BundleTooltipComponentAccessor)bt1).getItems().iterator();
                    Iterator i2 = ((BundleTooltipComponentAccessor)bt2).getItems().iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        class_1799 stack2;
                        class_1799 stack1 = (class_1799)i1.next();
                        if (class_1799.method_7973((class_1799)stack1, (class_1799)(stack2 = (class_1799)i2.next()))) continue;
                        return false;
                    }
                    if (!i1.hasNext() && !i2.hasNext()) continue;
                    return false;
                }
            }
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }
}

