/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.stackdeobf.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import dev.booky.stackdeobf.config.MappingProviderSerializer;
import dev.booky.stackdeobf.mappings.providers.AbstractMappingProvider;
import dev.booky.stackdeobf.mappings.providers.YarnMappingProvider;
import dev.booky.stackdeobf.util.VersionData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class StackDeobfConfig {
    private static final int CURRENT_VERSION = 2;
    @SerializedName(value="config-version-dont-touch-this")
    private int version;
    @SerializedName(value="inject-logger")
    private boolean logInject = true;
    @SerializedName(value="rewrite-every-log-message")
    private boolean rewriteEveryLogMessage = false;
    @SerializedName(value="mapping-type")
    private AbstractMappingProvider mappingProvider;

    private StackDeobfConfig() {
    }

    public static StackDeobfConfig load(VersionData versionData, Path configPath) throws IOException {
        StackDeobfConfig config;
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeHierarchyAdapter(AbstractMappingProvider.class, (Object)new MappingProviderSerializer(versionData)).create();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                config = (StackDeobfConfig)gson.fromJson((Reader)reader, StackDeobfConfig.class);
            }
            if (config.version == 2) {
                return config;
            }
            if (config.version < 2) {
                config.rewriteEveryLogMessage = false;
            }
        } else {
            config = new StackDeobfConfig();
            config.mappingProvider = new YarnMappingProvider(versionData);
        }
        config.version = 2;
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        return config;
    }

    public boolean hasLogInjectEnabled() {
        return this.logInject;
    }

    public boolean shouldRewriteEveryLogMessage() {
        return this.rewriteEveryLogMessage;
    }

    public AbstractMappingProvider getMappingProvider() {
        return this.mappingProvider;
    }
}

