/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.impl.common.CommonNetworkHandler;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.EnvironmentUtil;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_1657;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworkHandler
extends CommonNetworkHandler {
    FabricNetworkHandler(class_2960 channel, int protocolVersion) {
        super(channel, protocolVersion);
    }

    @Override
    protected <M> NetworkMessage<M> createMessage(CommonNetworkHandler.MessageNetworkPayload<M> messagePayload) {
        return new FabricNetworkMessage<M>(messagePayload);
    }

    @Override
    public void register() {
        for (CommonNetworkHandler.MessageNetworkPayload messagePayload : this.messages) {
            Set<NetworkEnvironment> list = messagePayload.getPayload().getHandlerEnvironment();
            if (list.contains((Object)NetworkEnvironment.CLIENT)) {
                EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.registerReceiver(messagePayload));
            }
            if (!list.contains((Object)NetworkEnvironment.SERVER)) continue;
            ServerPlayNetworking.registerGlobalReceiver((class_2960)messagePayload.getMessageId(), (server, player, handler, buffer, responseSender) -> {
                Object message = messagePayload.read(buffer);
                messagePayload.handle(CastUtil.uncheckedCast(message), new FabricNetworkContext(messagePayload.getMessageId(), NetworkEnvironment.SERVER, (class_1657)player, (class_1255<?>)server));
            });
        }
    }

    public static class FabricNetworkMessage<M>
    extends CommonNetworkHandler.CommonNetworkMessage<M> {
        FabricNetworkMessage(CommonNetworkHandler.MessageNetworkPayload<M> messagePayload) {
            super(messagePayload);
        }

        @Override
        public void sendPacketToPlayer(class_3222 player, M message) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.messagePayload.getMessageId(), (class_2540)this.writeMessage(message));
        }

        @Override
        public void sendPacketToConnection(class_2535 connection, M message) {
            connection.method_10743(ServerPlayNetworking.createS2CPacket((class_2960)this.messagePayload.getMessageId(), (class_2540)this.writeMessage(message)));
        }

        @Override
        public void sendPacketToServer(M message) {
            EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.send(this.messagePayload.getMessageId(), this.writeMessage(message)));
        }

        private class_2540 writeMessage(M message) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            this.messagePayload.write(message, buffer);
            return buffer;
        }
    }

    public static class FabricNetworkContext
    extends CommonNetworkHandler.CommonNetworkContext {
        private final NetworkEnvironment environment;
        private final class_1657 player;
        private final class_1255<?> executor;

        FabricNetworkContext(class_2960 messageId, NetworkEnvironment environment, class_1657 player, class_1255<?> executor) {
            super(messageId);
            this.environment = environment;
            this.player = player;
            this.executor = executor;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public class_1657 getPlayer() {
            return this.player;
        }

        @Override
        public CompletableFuture<Void> execute(Runnable runnable) {
            if (!this.executor.method_18854()) {
                return this.executor.method_5382(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Client {
        private Client() {
        }

        private static void send(class_2960 messageId, class_2540 buffer) {
            ClientPlayNetworking.send((class_2960)messageId, (class_2540)buffer);
        }

        private static void registerReceiver(CommonNetworkHandler.MessageNetworkPayload<?> messagePayload) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)messagePayload.getMessageId(), (client, packetListener, buffer, responseSender) -> {
                Object message = messagePayload.read(buffer);
                messagePayload.handle(CastUtil.uncheckedCast(message), new FabricNetworkContext(messagePayload.getMessageId(), NetworkEnvironment.CLIENT, (class_1657)client.field_1724, (class_1255<?>)client));
            });
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(class_2960 location, int protocolVersion) {
            return new FabricNetworkHandler(location, protocolVersion);
        }
    }
}

