/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkPayload;
import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;

public class DataHolderMenuPayload
implements NetworkPayload<DataHolderMenuMessage> {
    @Override
    public Set<NetworkEnvironment> getHandlerEnvironment() {
        return NetworkEnvironment.BOTH;
    }

    @Override
    public void write(DataHolderMenuMessage message, class_2540 buffer) {
        buffer.method_52997(message.containerId);
        buffer.method_52998(message.index);
        buffer.method_10804(message.dataHolderBuffer.readableBytes());
        buffer.method_52975((ByteBuf)message.dataHolderBuffer);
        message.dataHolderBuffer.release();
    }

    @Override
    public DataHolderMenuMessage read(class_2540 buffer) {
        byte containerId = buffer.readByte();
        short index = buffer.readShort();
        class_2540 dataHolderBuffer = new class_2540(Unpooled.wrappedBuffer((byte[])buffer.method_10795()));
        return new DataHolderMenuMessage(containerId, index, dataHolderBuffer);
    }

    @Override
    public void handle(DataHolderMenuMessage message, NetworkContext context) {
        context.executeOnMainThread(() -> {
            class_1657 player = context.getPlayer();
            try {
                if (player != null) {
                    this.updateDataHolder(context.getPlayer().field_7512, context.getEnvironment(), message);
                }
            }
            finally {
                message.dataHolderBuffer.release();
            }
        });
    }

    private void updateDataHolder(class_1703 menuToTest, NetworkEnvironment environment, DataHolderMenuMessage message) {
        this.testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> menu.setDataHolder(environment, message.index, message.dataHolderBuffer));
    }

    private Optional<UContainerMenu> testContainerMenu(class_1703 menu, int containerId) {
        if (menu instanceof UContainerMenu) {
            UContainerMenu uContainer = (UContainerMenu)menu;
            if (menu.field_7763 == containerId) {
                return Optional.of(uContainer);
            }
        }
        return Optional.empty();
    }

    public record DataHolderMenuMessage(int containerId, int index, class_2540 dataHolderBuffer) {
    }
}

