/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.update;

import info.u_team.u_team_core.internal.shade.net.hycrafthd.update_checker.UpdateChecker;
import info.u_team.u_team_core.internal.shade.net.hycrafthd.update_checker.Version;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;

public class UpdateResolver {
    public static final String URL_ENTRY = "uteamcore:update_url";

    public static void load() {
        List<UpdateChecker.Mod> mods = FabricLoader.getInstance().getAllMods().stream().map(container -> {
            ModMetadata metaData = container.getMetadata();
            if (metaData.containsCustomValue(URL_ENTRY)) {
                String modid = metaData.getId();
                String currentVersion = metaData.getVersion().getFriendlyString();
                String updateUrl = metaData.getCustomValue(URL_ENTRY).getAsString();
                return Optional.ofNullable(new UpdateChecker.Mod(modid, currentVersion, updateUrl));
            }
            return Optional.empty();
        }).flatMap(Optional::stream).collect(Collectors.toList());
        UpdateChecker.check(class_155.method_16673().method_48019(), mods, string -> {
            try {
                return new Version<net.fabricmc.loader.api.Version>(){
                    private final net.fabricmc.loader.api.Version version;
                    {
                        this.version = net.fabricmc.loader.api.Version.parse((String)string);
                    }

                    @Override
                    public int compareTo(Version<?> o) {
                        return this.version.compareTo((Object)((net.fabricmc.loader.api.Version)o.getImpl()));
                    }

                    @Override
                    public net.fabricmc.loader.api.Version getImpl() {
                        return this.version;
                    }

                    public String toString() {
                        return this.version.getFriendlyString();
                    }
                };
            }
            catch (VersionParsingException ex) {
                throw new RuntimeException("Cannot parse version for update checker", ex);
            }
        });
    }
}

