/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.function.Supplier;
import traben.entity_texture_features.ETFVersionDifferenceManager;
import traben.tconfig.TConfig;
import traben.tconfig.TConfigLog;

public class TConfigHandler<T extends TConfig> {
    private final Supplier<T> newConfigSupplier;
    private final String configFileName;
    private final Class<T> configClass;
    private final String logID;
    private T CONFIG;

    public TConfigHandler(Supplier<T> newConfigSupplier, String configFileName, String logID) {
        this.newConfigSupplier = newConfigSupplier;
        this.logID = logID;
        this.configFileName = configFileName.endsWith(".json") ? configFileName : configFileName + ".json";
        this.configClass = Objects.requireNonNull(((TConfig)newConfigSupplier.get()).getClass());
        this.loadFromFile();
    }

    public T getConfig() {
        if (this.CONFIG == null) {
            this.loadFromFile();
        }
        return this.CONFIG;
    }

    public void setConfig(T CONFIG) {
        this.CONFIG = CONFIG;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TConfigHandler that = (TConfigHandler)o;
        return this.getConfig().getClass().equals(that.getConfig().getClass());
    }

    public boolean configEquals(Object that) {
        if (this.CONFIG == that) {
            return true;
        }
        if (that == null || this.CONFIG.getClass() != that.getClass()) {
            return false;
        }
        return this.toJson().equals(this.toJson(that));
    }

    public int hashCode() {
        return Objects.hash(this.newConfigSupplier, this.CONFIG, this.configFileName, this.configClass);
    }

    public void saveToFile() {
        if (ETFVersionDifferenceManager.getConfigDirectory() == null) {
            return;
        }
        File config = new File(ETFVersionDifferenceManager.getConfigDirectory().toFile(), this.configFileName);
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(this.toJson());
            fileWriter.close();
        }
        catch (IOException e) {
            TConfigLog.logError(this.logID, "Config file could not be saved: " + e.getMessage());
        }
    }

    public String toJson() {
        return this.toJson(this.CONFIG);
    }

    public String toJson(Object config) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(config);
    }

    public void loadFromFile() {
        if (ETFVersionDifferenceManager.getConfigDirectory() == null) {
            this.CONFIG = (TConfig)this.newConfigSupplier.get();
        }
        try {
            File config = new File(ETFVersionDifferenceManager.getConfigDirectory().toFile(), this.configFileName);
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    this.CONFIG = this.fromJson(fileReader);
                    fileReader.close();
                    this.saveToFile();
                }
                catch (IOException e) {
                    TConfigLog.log(this.logID, "Config could not be loaded, using defaults");
                    this.CONFIG = (TConfig)this.newConfigSupplier.get();
                    this.saveToFile();
                }
            } else {
                this.CONFIG = (TConfig)this.newConfigSupplier.get();
                this.saveToFile();
            }
            if (this.CONFIG == null) {
                TConfigLog.log(this.logID, "Config was null, using defaults");
                this.CONFIG = (TConfig)this.newConfigSupplier.get();
                this.saveToFile();
            }
        }
        catch (Exception e) {
            TConfigLog.logError(this.logID, "Config was corrupt or broken, using defaults");
            e.printStackTrace();
            this.CONFIG = (TConfig)this.newConfigSupplier.get();
            this.saveToFile();
        }
    }

    public T fromJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (T)((TConfig)gson.fromJson(json, this.configClass));
    }

    public T fromJson(FileReader json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (T)((TConfig)gson.fromJson((Reader)json, this.configClass));
    }

    public T copyOfConfig() {
        return this.fromJson(this.toJson());
    }

    public boolean doesGUI() {
        return ((TConfig)this.getConfig()).doesGUI();
    }
}

