/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.PresetPoseButtonWidget;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.PosePreset;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5676;

public class ArmorStandPresetsScreen
extends AbstractArmorStandScreen {
    private static final int CONTROL_WIDTH = 120;
    private static final int CONTROL_HEIGHT = 16;
    private static final int BUTTONS_PER_PAGE = 6;
    private final ArrayList<PresetPoseButtonWidget> presetButtons = new ArrayList();
    private IconButtonWidget prevPageButton;
    private IconButtonWidget nextPageButton;
    private LabelWidget pageLabel;
    private int page = 0;
    private PosePreset.Source source = PosePreset.Source.ALL;
    private PosePreset.Category category = PosePreset.Category.ALL;
    private List<PosePreset> matchingPresets = new ArrayList<PosePreset>();

    public ArmorStandPresetsScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.PRESETS.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.PRESETS;
    }

    @Override
    protected void initStart() {
        super.initStart();
        this.presetButtons.clear();
    }

    @Override
    protected void initRight() {
        super.initRight();
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.presets.source.label"), this.field_22789 - 4, this.field_22790 - 4 - 128 - 18 - 20 - 16 - 13 - 6).alignedBottom().justifiedRight().shiftForPadding().build());
        this.method_37063((class_364)class_5676.method_32606(PosePreset.Source::getDisplayName).method_32620(PosePreset.Source.getSources()).method_32619((Object)PosePreset.Source.ALL).method_32616().method_32617(this.field_22789 - 4 - 120, this.field_22790 - 4 - 128 - 16 - 20 - 16 - 13 - 6, 120, 16, (class_2561)class_2561.method_43471((String)"armorstands.presets.source.label"), (button, source) -> this.filter((PosePreset.Source)((Object)source))));
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.presets.category.label"), this.field_22789 - 4, this.field_22790 - 4 - 128 - 18 - 20).alignedBottom().justifiedRight().shiftForPadding().build());
        this.method_37063((class_364)class_5676.method_32606(PosePreset.Category::getDisplayName).method_32620(PosePreset.Category.getCategories()).method_32619((Object)PosePreset.Category.ALL).method_32616().method_32617(this.field_22789 - 4 - 120, this.field_22790 - 4 - 128 - 16 - 20, 120, 16, (class_2561)class_2561.method_43471((String)"armorstands.presets.category.label"), (button, category) -> this.filter((PosePreset.Category)((Object)category))));
        for (int i = 6; i > 0; --i) {
            this.presetButtons.add((PresetPoseButtonWidget)this.method_37063((class_364)new PresetPoseButtonWidget(this.field_22789 - 4 - 120, this.field_22790 - 4 - i * 16 - i * 2 - 20, 120, 16)));
        }
        this.prevPageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget(this.field_22789 - 4 - 120, this.field_22790 - 4 - 20, 12, (class_2561)class_2561.method_43471((String)"armorstands.presets.previous"), button -> this.previousPage()));
        this.nextPageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget(this.field_22789 - 4 - 20, this.field_22790 - 4 - 20, 13, (class_2561)class_2561.method_43471((String)"armorstands.presets.next"), button -> this.nextPage()));
        int maxPage = class_3532.method_15386((float)((float)PosePreset.getPresets(this.source, this.category).size() / 6.0f)) - 1;
        this.pageLabel = this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43469((String)"armorstands.presets.page", (Object[])new Object[]{this.page + 1, maxPage + 1}), this.field_22789 - 4 - 60, this.field_22790 - 4 - 10).alignedMiddle().justifiedCenter().build());
    }

    @Override
    protected void initEnd() {
        this.updateFilters();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isMouseOverList(mouseX, mouseY)) {
            if (verticalAmount < 0.0) {
                this.nextPage();
            } else {
                this.previousPage();
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void filter(PosePreset.Source source) {
        this.source = source;
        this.updateFilters();
    }

    private void filter(PosePreset.Category category) {
        this.category = category;
        this.updateFilters();
    }

    private void updateFilters() {
        this.matchingPresets = PosePreset.getPresets(this.source, this.category);
        this.setPage(0);
    }

    private void setPage(int page) {
        int maxPage = Math.max(0, class_3532.method_15386((float)((float)this.matchingPresets.size() / 6.0f)) - 1);
        this.page = page;
        List<PosePreset> presets = this.matchingPresets.subList(page * 6, Math.min((page + 1) * 6, this.matchingPresets.size()));
        for (int i = 0; i < 6; ++i) {
            if (i < presets.size()) {
                this.presetButtons.get(i).setPose(presets.get(i));
                this.presetButtons.get((int)i).field_22764 = true;
                continue;
            }
            this.presetButtons.get((int)i).field_22764 = false;
        }
        if (this.presetButtons.contains(this.method_25399())) {
            this.method_25395((class_364)this.presetButtons.get(0));
        }
        this.prevPageButton.field_22763 = this.page > 0;
        this.nextPageButton.field_22763 = this.page < maxPage;
        this.pageLabel.setText((class_2561)class_2561.method_43469((String)"armorstands.presets.page", (Object[])new Object[]{this.page + 1, maxPage + 1}));
    }

    private void nextPage() {
        int maxPage = class_3532.method_15386((float)((float)this.matchingPresets.size() / 6.0f)) - 1;
        if (this.page < maxPage) {
            this.setPage(this.page + 1);
        }
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    private boolean isMouseOverList(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_22789 - 4 - 120) && mouseX < (double)(this.field_22789 - 4) && mouseY >= (double)(this.field_22790 - 4 - 20 - 96 - 14) && mouseY < (double)(this.field_22790 - 4 - 20);
    }
}

