/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.entity.ArmorStandInventory;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.packet.s2c.ClientUpdatePacket;
import me.roundaround.armorstands.util.ArmorStandEditor;
import me.roundaround.armorstands.util.HasArmorStand;
import me.roundaround.armorstands.util.HasArmorStandEditor;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ArmorStandScreenHandler
extends class_1703
implements HasArmorStand,
HasArmorStandEditor {
    private static final class_2960 EMPTY_MAINHAND_ARMOR_SLOT = new class_2960("item/empty_slot_sword");
    private static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_2960[] EMPTY_HAND_SLOT_TEXTURES = new class_2960[]{EMPTY_MAINHAND_ARMOR_SLOT, class_1723.field_21673};
    private static final class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private static final class_1304[] HAND_SLOT_ORDER = new class_1304[]{class_1304.field_6173, class_1304.field_6171};
    private final class_1661 playerInventory;
    private final class_1531 armorStand;
    private final ScreenType screenType;
    private final ArmorStandInventory inventory;
    private final ArmorStandEditor editor;
    private final ArrayList<Pair<class_1735, class_1304>> armorSlots = new ArrayList();

    public ArmorStandScreenHandler(int syncId, class_1661 playerInventory, class_1531 armorStand, ScreenType screenType) {
        super(ArmorStandsMod.ARMOR_STAND_SCREEN_HANDLER_TYPE, syncId);
        this.playerInventory = playerInventory;
        this.armorStand = armorStand;
        this.screenType = screenType;
        this.inventory = new ArmorStandInventory(armorStand);
        this.editor = playerInventory.field_7546 instanceof class_3222 ? ArmorStandEditor.get((class_3222)playerInventory.field_7546, armorStand) : null;
        this.inventory.method_5435(this.playerInventory.field_7546);
        if (this.screenType != null && this.screenType.usesInventory()) {
            this.initSlots();
        }
    }

    public ArmorStandScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory, (class_1531)playerInventory.field_7546.method_37908().method_8469(buf.readInt()), ScreenType.fromId(buf.method_19772()));
    }

    private void initSlots() {
        int i;
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)this.playerInventory, col, 8 + col * 18, 142));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, col + (row + 1) * 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (i = 0; i < 2; ++i) {
            final int index = i;
            final class_1304 equipmentSlot = HAND_SLOT_ORDER[i];
            class_1735 slot = this.method_7621(new class_1735(this.inventory, index, 116, 44 + index * 18){

                public void method_53512(class_1799 stack) {
                    ArmorStandScreenHandler.this.armorStand.method_5673(equipmentSlot, stack);
                    this.method_7668();
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_HAND_SLOT_TEXTURES[index]);
                }

                public boolean method_7674(class_1657 player) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_7337() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, equipmentSlot)) {
                        return false;
                    }
                    return super.method_7674(player);
                }

                public boolean method_7680(class_1799 stack) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_7337() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, equipmentSlot)) {
                        return false;
                    }
                    return super.method_7680(stack);
                }
            });
            this.armorSlots.add((Pair<class_1735, class_1304>)Pair.of((Object)slot, (Object)equipmentSlot));
        }
        for (i = 0; i < 4; ++i) {
            final class_1304 equipmentSlot = EQUIPMENT_SLOT_ORDER[i];
            class_1735 slot = this.method_7621(new class_1735(this.inventory, 5 - i, 44, 8 + i * 18){

                public void method_53512(class_1799 stack) {
                    ArmorStandScreenHandler.this.armorStand.method_5673(equipmentSlot, stack);
                    this.method_7668();
                }

                public int method_7675() {
                    return 1;
                }

                public boolean method_7674(class_1657 player) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_7337() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, equipmentSlot)) {
                        return false;
                    }
                    return super.method_7674(player);
                }

                public boolean method_7680(class_1799 stack) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_7337() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, equipmentSlot)) {
                        return false;
                    }
                    return equipmentSlot == class_1531.method_32326((class_1799)stack);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.method_5927()]);
                }
            });
            this.armorSlots.add((Pair<class_1735, class_1304>)Pair.of((Object)slot, (Object)equipmentSlot));
        }
    }

    public ImmutableList<Pair<class_1735, class_1304>> getArmorSlots() {
        return ImmutableList.copyOf(this.armorSlots);
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    @Override
    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    @Override
    public ArmorStandEditor getEditor() {
        return this.editor;
    }

    public class_1661 getPlayerInventory() {
        return this.playerInventory;
    }

    public void method_7623() {
        if (this.playerInventory.field_7546 instanceof class_3222) {
            ClientUpdatePacket.sendToClient((class_3222)this.playerInventory.field_7546, this.armorStand);
        }
        super.method_7623();
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        if (index < 0 || index >= this.field_7761.size()) {
            return class_1799.field_8037;
        }
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot == null || !slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 stack = slot.method_7677();
        class_1799 originalStack = stack.method_7972();
        if (index < 36 ? !this.tryTransferArmor(stack) && !this.tryTransferToMainHand(stack) && !this.tryTransferToOffHand(stack) : !this.method_7616(stack, 0, 36, false)) {
            return class_1799.field_8037;
        }
        if (stack.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return originalStack;
    }

    private boolean tryTransferArmor(class_1799 stack) {
        class_1304 equipmentSlot = class_1531.method_32326((class_1799)stack);
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, equipmentSlot)) {
            return false;
        }
        int targetIndex = this.field_7761.size() - 1 - equipmentSlot.method_5927();
        return this.method_7616(stack, targetIndex, targetIndex + 1, false);
    }

    private boolean tryTransferToMainHand(class_1799 stack) {
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_1304.field_6173)) {
            return false;
        }
        int targetIndex = 36;
        return this.method_7616(stack, targetIndex, targetIndex + 1, false);
    }

    private boolean tryTransferToOffHand(class_1799 stack) {
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_1304.field_6171)) {
            return false;
        }
        int targetIndex = 37;
        return this.method_7616(stack, targetIndex, targetIndex + 1, false);
    }

    public static boolean isSlotDisabled(class_1531 armorStand, class_1304 slot) {
        return (((ArmorStandEntityAccessor)armorStand).getDisabledSlots() & 1 << slot.method_5926()) != 0;
    }

    public static class Factory
    implements ExtendedScreenHandlerFactory {
        private final ScreenType screenType;
        private final class_1531 armorStand;

        private Factory(ScreenType screenType, class_1531 armorStand) {
            this.screenType = screenType;
            this.armorStand = armorStand;
        }

        public static Factory create(ScreenType screenType, class_1531 armorStand) {
            return new Factory(screenType, armorStand);
        }

        public class_2561 method_5476() {
            return this.screenType.getDisplayName();
        }

        public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
            return new ArmorStandScreenHandler(syncId, playerInventory, this.armorStand, this.screenType);
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_53002(this.armorStand.method_5628());
            buf.method_10814(this.screenType.getId());
        }
    }
}

