/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ImprovedThreadLocal<T>
extends ThreadLocal<T> {
    private static final Map<Thread, Map<ThreadLocal<?>, Object>> STRONG_REFERENCES_TO_TL_VALUES = Collections.synchronizedMap(new WeakHashMap());
    private static final ThreadLocal<WeakReference<Map<ThreadLocal<?>, Object>>> WR_THREAD_LOCALS = new ThreadLocal<WeakReference<Map<ThreadLocal<?>, Object>>>(){

        @Override
        protected WeakReference<Map<ThreadLocal<?>, Object>> initialValue() {
            WeakHashMap value = new WeakHashMap();
            STRONG_REFERENCES_TO_TL_VALUES.put(Thread.currentThread(), value);
            return new WeakReference(value);
        }
    };

    @Override
    public T get() {
        Object value;
        Map threadLocalMap = (Map)WR_THREAD_LOCALS.get().get();
        if (threadLocalMap == null || (value = threadLocalMap.get(this)) == null && !threadLocalMap.containsKey(this)) {
            value = this.initialValue();
            this.set(value);
        }
        return value;
    }

    @Override
    public void set(T value) {
        ((Map)WR_THREAD_LOCALS.get().get()).put(this, value);
    }

    @Override
    public void remove() {
        ((Map)WR_THREAD_LOCALS.get().get()).remove(this);
    }
}

