/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.internal.selector;

import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ClockKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import opekope2.optigui.filter.ConjunctionFilter;
import opekope2.optigui.filter.DisjunctionFilter;
import opekope2.optigui.filter.EqualityFilter;
import opekope2.optigui.filter.IFilter;
import opekope2.optigui.filter.PreProcessorFilter;
import opekope2.optigui.interaction.Interaction;
import opekope2.optigui.internal.selector.AbstractListSelector;
import opekope2.optigui.internal.util.UtilKt;
import opekope2.optigui.util.NumberOrRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u001e\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00020\bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0017\u001a\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lopekope2/optigui/internal/selector/DateSelector;", "Lopekope2/optigui/internal/selector/AbstractListSelector;", "Lkotlin/Pair;", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "Lopekope2/optigui/util/NumberOrRange;", "<init>", "()V", "", "parsedSelectors", "Lopekope2/optigui/filter/DisjunctionFilter;", "Lopekope2/optigui/interaction/Interaction;", "createFilter", "(Ljava/util/Collection;)Lopekope2/optigui/filter/DisjunctionFilter;", "", "monthName", "getMonth", "(Ljava/lang/String;)Ljava/time/Month;", "invalidSelectors", "", "parseFailed", "(Ljava/util/Collection;)Ljava/lang/Void;", "selector", "parseSelector", "(Ljava/lang/String;)Lkotlin/Pair;", "interaction", "transformInteraction", "(Lopekope2/optigui/interaction/Interaction;)Ljava/lang/String;", "Lkotlinx/datetime/LocalDate;", "getToday", "()Lkotlinx/datetime/LocalDate;", "today", "optigui"})
@SourceDebugExtension(value={"SMAP\nIndependentSelectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndependentSelectors.kt\nopekope2/optigui/internal/selector/DateSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n*S KotlinDebug\n*F\n+ 1 IndependentSelectors.kt\nopekope2/optigui/internal/selector/DateSelector\n*L\n31#1:74\n31#1:75,3\n*E\n"})
public final class DateSelector
extends AbstractListSelector<Pair<? extends Month, ? extends NumberOrRange>> {
    private final LocalDate getToday() {
        return ClockKt.todayIn((Clock)((Clock)Clock.System.INSTANCE), (TimeZone)TimeZone.Companion.currentSystemDefault());
    }

    @Override
    @Nullable
    protected Pair<Month, NumberOrRange> parseSelector(@NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        char[] cArray = new char[]{'@'};
        List parts = StringsKt.split$default((CharSequence)selector, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            return null;
        }
        String rawMonth = (String)parts.get(0);
        String rawDay = (String)parts.get(1);
        Month month = this.getMonth(rawMonth);
        if (month == null) {
            return null;
        }
        Month month2 = month;
        NumberOrRange day = NumberOrRange.Companion.tryParse(rawDay);
        return TuplesKt.to((Object)month2, (Object)day);
    }

    @Override
    @NotNull
    protected Void parseFailed(@NotNull Collection<String> invalidSelectors) {
        Intrinsics.checkNotNullParameter(invalidSelectors, (String)"invalidSelectors");
        throw new RuntimeException("Invalid dates: " + UtilKt.joinNotFound(invalidSelectors));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DisjunctionFilter<Interaction> createFilter(@NotNull Collection<? extends Pair<? extends Month, ? extends NumberOrRange>> parsedSelectors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parsedSelectors, (String)"parsedSelectors");
        Iterable $this$map$iv = parsedSelectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IFilter iFilter;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Month month = (Month)pair.component1();
            NumberOrRange day = (NumberOrRange)pair.component2();
            PreProcessorFilter monthFilter2 = PreProcessorFilter.Companion.nullGuarded((Function1)new Function1<Interaction, Month>(this){
                final /* synthetic */ DateSelector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Month invoke(@NotNull Interaction it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return DateSelector.access$getToday(this.this$0).getMonth();
                }
            }, "Get month", null, (IFilter)new EqualityFilter<Month>(month));
            Object object = day;
            if (object == null || (object = ((NumberOrRange)object).toFilter()) == null) {
                iFilter = monthFilter2;
            } else {
                Object dayFilter = object;
                IFilter[] iFilterArray = new IFilter[]{monthFilter2, PreProcessorFilter.Companion.nullGuarded((Function1)new Function1<Interaction, Integer>(this){
                    final /* synthetic */ DateSelector this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final Integer invoke(@NotNull Interaction it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return DateSelector.access$getToday(this.this$0).getDayOfMonth();
                    }
                }, "Get day of month", null, dayFilter)};
                iFilter = new ConjunctionFilter(iFilterArray);
            }
            collection.add(iFilter);
        }
        Collection collection = (List)destination$iv$iv;
        return new DisjunctionFilter<Interaction>(collection);
    }

    @Override
    @NotNull
    protected String transformInteraction(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        LocalDate today = this.getToday();
        String string = today.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string + "@" + today.getDayOfMonth();
    }

    private final Month getMonth(String monthName) {
        return switch (monthName) {
            case "jan", "1", "january" -> Month.JANUARY;
            case "feb", "february", "2" -> Month.FEBRUARY;
            case "mar", "march", "3" -> Month.MARCH;
            case "april", "apr", "4" -> Month.APRIL;
            case "may", "5" -> Month.MAY;
            case "jun", "june", "6" -> Month.JUNE;
            case "jul", "july", "7" -> Month.JULY;
            case "augustus", "aug", "8" -> Month.AUGUST;
            case "september", "sep", "9" -> Month.SEPTEMBER;
            case "10", "oct", "spooktober", "october" -> Month.OCTOBER;
            case "november", "nov", "11" -> Month.NOVEMBER;
            case "dec", "december", "12" -> Month.DECEMBER;
            default -> null;
        };
    }

    public static final /* synthetic */ LocalDate access$getToday(DateSelector $this) {
        return $this.getToday();
    }
}

