/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import com.hypherionmc.craterlib.api.events.client.CraterClientTickEvent;
import com.hypherionmc.craterlib.api.events.client.CraterSinglePlayerEvent;
import com.hypherionmc.craterlib.api.events.client.LateInitEvent;
import com.hypherionmc.craterlib.api.events.client.PlayerJoinRealmEvent;
import com.hypherionmc.craterlib.api.events.client.ScreenEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.craterlib.core.event.annot.CraterEventListener;
import com.hypherionmc.craterlib.nojang.client.BridgedMinecraft;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import me.hypherionmc.simplerpc.Utils;
import me.hypherionmc.simplerpc.core.configuration.GameType;
import me.hypherionmc.simplerpc.core.discord.RichPresenceCore;
import me.hypherionmc.simplerpc.core.discord.RichPresenceEvents;

public class SimpleRPCClient {
    public static RichPresenceCore rpcCore;
    public static RichPresenceEvents rpcEvents;
    public static ResourceIdentifier DISCORD;
    public static ResourceIdentifier DISCORD_TWO;

    public static void setupEvents() {
        CraterEventBus.INSTANCE.registerEventListener(SimpleRPCClient.class);
    }

    @CraterEventListener
    public static void init(LateInitEvent event) {
        rpcCore = new RichPresenceCore(new Utils(), event.getMinecraft().getGameDirectory().getAbsolutePath(), event.getOptions().getLanguage() == null ? "en_us" : event.getOptions().getLanguage());
        rpcEvents = rpcCore.getEvents();
    }

    @CraterEventListener
    public static void playerJoinGame(CraterSinglePlayerEvent.PlayerLogin event) {
        if (event.getPlayer().getStringUUID().equals(BridgedMinecraft.getInstance().getPlayer().getStringUUID())) {
            rpcCore.setLangCode(BridgedMinecraft.getInstance().getOptions().getLanguage());
            rpcEvents.joinGame();
        }
    }

    @CraterEventListener
    public static void screenOpenEvent(ScreenEvent.Opening event) {
        if (event.getScreen().isTitleScreen()) {
            rpcCore.setLangCode(BridgedMinecraft.getInstance().getOptions().getLanguage());
            rpcEvents.mainMenuRPC();
        }
        if (event.getScreen().isRealmsScreen()) {
            rpcCore.setLangCode(BridgedMinecraft.getInstance().getOptions().getLanguage());
            rpcEvents.realmRPC();
        }
        if (event.getScreen().isServerBrowserScreen()) {
            rpcCore.setLangCode(BridgedMinecraft.getInstance().getOptions().getLanguage());
            rpcEvents.serverListRPC();
        }
        if (event.getScreen().isLoadingScreen()) {
            rpcCore.setLangCode(BridgedMinecraft.getInstance().getOptions().getLanguage());
            rpcEvents.joiningGameRPC();
        }
    }

    @CraterEventListener
    public static void playerJoinRealm(PlayerJoinRealmEvent event) {
        Utils.realmsServer = event.getServer();
    }

    public static void setServerConfig(String config) {
    }

    @CraterEventListener
    public static void clientTick(CraterClientTickEvent event) {
        if (event.getLevel() != null && event.getLevel().isClientSide() && rpcEvents != null && event.getLevel().getGameTime() % 40L == 0L) {
            if (BridgedMinecraft.getInstance().isRealmServer()) {
                rpcEvents.ingameRPC(GameType.REALM);
            } else {
                rpcEvents.ingameRPC(BridgedMinecraft.getInstance().isSinglePlayer() ? GameType.SINGLE : GameType.MULTIPLAYER);
            }
        }
    }

    static {
        DISCORD = new ResourceIdentifier("simplerpc:widget/discord_one");
        DISCORD_TWO = new ResourceIdentifier("simplerpc:widget/discord_two");
    }
}

