/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.adt;

import java.util.BitSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;

public final class SparseIntMatrix {
    private final BitSet[] IS_PRESENT;
    private final ReentrantReadWriteLock[] LOCKS;
    private final int WIDTH;
    private final int HEIGHT;
    private final int[][] MATRIX;
    private final int SECTOR_POWER;
    private final int SECTORS_PER_ROW;
    private final int POINTS_PER_SECTOR_ROW;
    private final int SECTOR_SIZE;
    private final int SECTOR_COORD_MASK;

    public SparseIntMatrix(int width, int height, int maxSectorPower) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException(String.format("Width and height must be positive: %sx%s", width, height));
        }
        this.WIDTH = width;
        this.HEIGHT = height;
        if (maxSectorPower <= 0) {
            throw new IllegalArgumentException(String.format("Max sector power must be positive: %s", maxSectorPower));
        }
        this.SECTOR_POWER = SparseIntMatrix.min(maxSectorPower, SparseIntMatrix.largestPowerOf2LessThanOrEqual(this.WIDTH), SparseIntMatrix.largestPowerOf2LessThanOrEqual(this.HEIGHT));
        this.SECTORS_PER_ROW = SparseIntMatrix.shiftRightRoundUp(this.WIDTH, this.SECTOR_POWER);
        int rows = SparseIntMatrix.shiftRightRoundUp(this.HEIGHT, this.SECTOR_POWER);
        this.POINTS_PER_SECTOR_ROW = 1 << this.SECTOR_POWER;
        this.SECTOR_COORD_MASK = this.POINTS_PER_SECTOR_ROW - 1;
        this.SECTOR_SIZE = this.POINTS_PER_SECTOR_ROW * this.POINTS_PER_SECTOR_ROW;
        this.MATRIX = new int[this.SECTORS_PER_ROW * rows][];
        this.IS_PRESENT = (BitSet[])Stream.generate(() -> new BitSet(this.SECTOR_SIZE)).limit((long)this.SECTORS_PER_ROW * (long)rows).toArray(BitSet[]::new);
        this.LOCKS = (ReentrantReadWriteLock[])Stream.generate(ReentrantReadWriteLock::new).limit((long)this.SECTORS_PER_ROW * (long)rows).toArray(ReentrantReadWriteLock[]::new);
    }

    public int get(int x, int y) {
        this.checkInBounds(x, y);
        int sectorIndex = this.sectorIndex(x, y);
        int indexInSector = this.indexInSector(x, y);
        ReentrantReadWriteLock.ReadLock lock = this.LOCKS[sectorIndex].readLock();
        lock.lock();
        if (!this.IS_PRESENT[sectorIndex].get(indexInSector)) {
            throw new IllegalStateException(String.format("Point (%s, %s) has not been set", x, y));
        }
        int value = this.MATRIX[sectorIndex][indexInSector];
        lock.unlock();
        return value;
    }

    public boolean isSet(int x, int y) {
        this.checkInBounds(x, y);
        int sectorIndex = this.sectorIndex(x, y);
        int indexInSector = this.indexInSector(x, y);
        ReentrantReadWriteLock.ReadLock lock = this.LOCKS[sectorIndex].readLock();
        lock.lock();
        boolean isSet = this.IS_PRESENT[sectorIndex].get(indexInSector);
        lock.unlock();
        return isSet;
    }

    public void set(int x, int y, int value) {
        this.checkInBounds(x, y);
        int sectorIndex = this.sectorIndex(x, y);
        int indexInSector = this.indexInSector(x, y);
        ReentrantReadWriteLock.WriteLock lock = this.LOCKS[sectorIndex].writeLock();
        lock.lock();
        if (this.MATRIX[sectorIndex] == null) {
            this.MATRIX[sectorIndex] = new int[this.SECTOR_SIZE];
        }
        this.MATRIX[sectorIndex][indexInSector] = value;
        this.IS_PRESENT[sectorIndex].set(indexInSector);
        lock.unlock();
    }

    private void checkInBounds(int x, int y) {
        if (x < 0 || y < 0 || x >= this.WIDTH || y >= this.HEIGHT) {
            throw new IllegalArgumentException(String.format("Point (%s, %s) is out of bounds in a %sx%s matrix", x, y, this.WIDTH, this.HEIGHT));
        }
    }

    private int sectorIndex(int x, int y) {
        return (y >> this.SECTOR_POWER) * this.SECTORS_PER_ROW + (x >> this.SECTOR_POWER);
    }

    private int indexInSector(int x, int y) {
        int hCoord = x & this.SECTOR_COORD_MASK;
        int vCoord = y & this.SECTOR_COORD_MASK;
        return vCoord * this.POINTS_PER_SECTOR_ROW + hCoord;
    }

    private static int largestPowerOf2LessThanOrEqual(int num) {
        return Integer.numberOfTrailingZeros(Integer.highestOneBit(num));
    }

    private static int shiftRightRoundUp(int num, int amount) {
        int original = num >> amount;
        if ((num & num - 1) == 0) {
            return original;
        }
        return original + 1;
    }

    private static int min(int one, int two, int three) {
        return Math.min(one, Math.min(two, three));
    }
}

