/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.adapter;

import io.github.moremcmeta.moremcmeta.impl.client.adapter.RootResourcesAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ResourceCollection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public final class PackResourcesAdapter
implements ResourceCollection {
    private final class_3262 ORIGINAL;
    private final RootResourcesAdapter ROOT_RESOURCES;

    public PackResourcesAdapter(class_3262 original) {
        this.ORIGINAL = Objects.requireNonNull(original, "Original pack cannot be null");
        this.ROOT_RESOURCES = new RootResourcesAdapter(original);
    }

    @Override
    public InputStream find(class_3264 resourceType, class_2960 location) throws IOException {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(location, "Location cannot be null");
        if (RootResourcesAdapter.isRootResource(location)) {
            return this.ROOT_RESOURCES.find(resourceType, location);
        }
        class_7367 resourceSupplier = this.ORIGINAL.method_14405(resourceType, location);
        if (resourceSupplier == null) {
            throw new IOException(String.format("Could not find %s in pack type %s", location, resourceType));
        }
        return (InputStream)resourceSupplier.get();
    }

    @Override
    public boolean contains(class_3264 resourceType, class_2960 location) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(location, "Location cannot be null");
        return this.ROOT_RESOURCES.contains(resourceType, location) || !RootResourcesAdapter.isRootResource(location) && this.ORIGINAL.method_14405(resourceType, location) != null;
    }

    @Override
    public Collection<class_2960> list(class_3264 resourceType, String namespace, String pathStart, Predicate<String> fileFilter) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(namespace, "Namespace cannot be null");
        Objects.requireNonNull(pathStart, "Path start cannot be null");
        Objects.requireNonNull(fileFilter, "File filter cannot be null");
        if ("__moremcmeta_root__".equals(namespace)) {
            return this.ROOT_RESOURCES.list(resourceType, namespace, pathStart, fileFilter);
        }
        HashSet<class_2960> resources = new HashSet<class_2960>();
        class_3262.class_7664 output = (location, resourceSupplier) -> {
            if (fileFilter.test(location.method_12832())) {
                resources.add((class_2960)location);
            }
        };
        this.ORIGINAL.method_14408(resourceType, namespace, pathStart, output);
        return resources;
    }

    @Override
    public Set<String> namespaces(class_3264 resourceType) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        HashSet<String> namespaces = new HashSet<String>(this.ORIGINAL.method_14406(resourceType));
        namespaces.addAll(this.ROOT_RESOURCES.namespaces(resourceType));
        return namespaces;
    }

    @Override
    public class_2960 locateRootResource(String rootResource) {
        Objects.requireNonNull(rootResource, "Root resource name cannot be null");
        return this.ROOT_RESOURCES.locateRootResource(rootResource);
    }
}

