/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete;

import de.keksuccino.konkrete.PostClientInitTaskExecutor;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.platform.Services;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Konkrete {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "konkrete";
    public static final String VERSION = "1.9.2";
    public static final String MOD_LOADER = Services.PLATFORM.getPlatformName();
    @Deprecated(forRemoval=true)
    public static boolean isOptifineLoaded = false;

    public static void init() {
        if (Services.PLATFORM.isOnClient()) {
            LOGGER.info("[KONKRETE] Loading v1.9.2 in client-side mode on " + MOD_LOADER.toUpperCase() + "!");
        } else {
            LOGGER.info("[KONKRETE] Loading v1.9.2 in server-side mode on " + MOD_LOADER.toUpperCase() + "!");
        }
        LOGGER.info("---------------------------");
        LOGGER.info("KONKRETE SHIPS AND USES THE FOLLOWING LIBRARIES:");
        LOGGER.info(" ");
        LOGGER.info("Open Imaging Copyright \u00a9 2014 Dhyan Blum.");
        LOGGER.info("Open Imaging is licensed under Apache-2.0.");
        LOGGER.info(" ");
        LOGGER.info("JsonPath Copyright \u00a9 2017 Jayway.");
        LOGGER.info("JsonPath is licensed under Apache-2.0.");
        LOGGER.info(" ");
        LOGGER.info("Json-smart Copyright \u00a9 netplex.");
        LOGGER.info("Json-smart is licensed under Apache-2.0.");
        LOGGER.info(" ");
        LOGGER.info("Exp4j Copyright \u00a9 Frank Asseg.");
        LOGGER.info("Exp4j is licensed under Apache-2.0. https://github.com/fasseg/exp4j");
        LOGGER.info("---------------------------");
        if (Services.PLATFORM.isOnClient()) {
            try {
                Class.forName("optifine.Installer");
                isOptifineLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        LOGGER.info("[KONKRETE] Server-side modules initialized and ready to use!");
    }

    public static void onGameInitCompleted() {
        SoundHandler.init();
        SoundHandler.updateVolume();
        Konkrete.initLocals();
        LOGGER.info("[KONKRETE] Client-side modules initialized and ready to use!");
        PostClientInitTaskExecutor.executeAll();
    }

    private static void initLocals() {
        File f = new File("config/konkrete/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir(new class_2960(MOD_ID, "locals/en_us.local"), "en_us", f.getPath());
        Locals.copyLocalsFileToDir(new class_2960(MOD_ID, "locals/de_de.local"), "de_de", f.getPath());
        Locals.copyLocalsFileToDir(new class_2960(MOD_ID, "locals/pl_pl.local"), "pl_pl", f.getPath());
        Locals.copyLocalsFileToDir(new class_2960(MOD_ID, "locals/pt_br.local"), "pt_br", f.getPath());
        Locals.getLocalsFromDir(f.getPath());
    }

    public static void addPostClientInitTask(@NotNull String modId, @NotNull Runnable task) {
        PostClientInitTaskExecutor.addTask(modId, task);
    }

    @Deprecated
    public static void addPostLoadingEvent(@NotNull String modId, @NotNull Runnable task) {
        Konkrete.addPostClientInitTask(modId, task);
    }
}

