/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7924;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<class_2960, class_4763> vanillaEffects = new HashMap<class_2960, class_4763>();
    private final Map<class_2960, BiomeEffectModifier> effectsToApply = new HashMap<class_2960, BiomeEffectModifier>();

    public BiomeEffectsManager() {
        super("biome_effects");
    }

    @Override
    public void process(Map<class_2960, JsonElement> biomesJsons) {
        for (Map.Entry<class_2960, JsonElement> j : biomesJsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeEffectModifier effect = (BiomeEffectModifier)((Pair)BiomeEffectModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Biome Special Effect with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addEffect(id, effect);
        }
    }

    private void addEffect(class_2960 pathId, BiomeEffectModifier mod) {
        Optional<Set<class_2960>> explTargets = mod.explicitTargets();
        if (explTargets.isPresent()) {
            for (class_2960 explicitId : explTargets.get()) {
                this.effectsToApply.merge(explicitId, mod, BiomeEffectModifier::merge);
            }
        } else {
            this.effectsToApply.merge(pathId, mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void apply() {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            this.doApply(level.method_30349(), false);
        }
    }

    public void doApply(class_5455 registryAccess, boolean firstLogin) {
        if (firstLogin) {
            this.vanillaEffects.clear();
        }
        class_2378 biomeReg = (class_2378)registryAccess.method_33310(class_7924.field_41236).get();
        this.addAllWaterColors((class_2378<class_1959>)biomeReg);
        for (Map.Entry<class_2960, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            class_2960 biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.method_17966(biomeId);
            if (!biome.isPresent()) continue;
            class_4763 old = modifier.apply((class_1959)biome.get());
            this.vanillaEffects.put(biomeId, old);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void reset() {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_2378 biomeReg = (class_2378)level.method_30349().method_33310(class_7924.field_41236).get();
            for (Map.Entry<class_2960, class_4763> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.method_17966(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyInplace(bio, (class_4763)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
    }

    public void addAllWaterColors(class_2378<class_1959> biomeReg) {
        FluidPropertyModifier water;
        if (Polytone.sodiumOn && (water = Polytone.FLUID_PROPERTIES.getModifier((class_3611)class_3612.field_15910)) != null) {
            for (Map.Entry e : biomeReg.method_29722()) {
                class_322 class_3222;
                class_2960 id = ((class_5321)e.getKey()).method_29177();
                class_1959 b = (class_1959)e.getValue();
                BiomeEffectModifier original = this.effectsToApply.get(id);
                if (original != null && !original.waterColor().isEmpty() || !((class_3222 = water.getColormap()) instanceof Colormap)) continue;
                Colormap cl = (Colormap)class_3222;
                int col = cl.getColor(b, 0.0, 0.0);
                BiomeEffectModifier dummy = BiomeEffectModifier.ofWaterColor(col);
                this.addEffect(id, dummy);
            }
        }
    }
}

