/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.FileStorage;
import ch.endte.syncmatica.IFileStorage;
import ch.endte.syncmatica.LocalLitematicState;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RedirectFileStorage
implements IFileStorage {
    private final IFileStorage fs;
    private final Map<UUID, RedirectData> redirect = new HashMap<UUID, RedirectData>();

    public RedirectFileStorage() {
        this.fs = new FileStorage();
    }

    public void addRedirect(File file) {
        RedirectData red = new RedirectData(file);
        this.redirect.put(red.getHash(), red);
    }

    @Override
    public LocalLitematicState getLocalState(ServerPlacement placement) {
        UUID hashId = placement.getHash();
        if (this.redirect.containsKey(hashId) && hashId.equals(this.redirect.get(hashId).getHash())) {
            return LocalLitematicState.LOCAL_LITEMATIC_PRESENT;
        }
        return this.fs.getLocalState(placement);
    }

    @Override
    public File createLocalLitematic(ServerPlacement placement) {
        return this.fs.createLocalLitematic(placement);
    }

    @Override
    public File getLocalLitematic(ServerPlacement placement) {
        UUID hashId = placement.getHash();
        if (this.redirect.containsKey(hashId)) {
            RedirectData red = this.redirect.get(hashId);
            if (red.exists() && hashId.equals(red.getHash())) {
                return red.redirect;
            }
            this.redirect.remove(hashId);
        }
        return this.fs.getLocalLitematic(placement);
    }

    @Override
    public void setContext(Context con) {
        this.fs.setContext(con);
    }

    private class RedirectData {
        File redirect = null;
        UUID hash = null;
        long hashTimeStamp;

        RedirectData(File file) {
            this.redirect = file;
            this.getHash();
            if (this.hash == null) {
                file = null;
            }
        }

        UUID getHash() {
            if (this.hashTimeStamp == this.redirect.lastModified()) {
                return this.hash;
            }
            try {
                this.hash = SyncmaticaUtil.createChecksum(new FileInputStream(this.redirect));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.hashTimeStamp = this.redirect.lastModified();
            return this.hash;
        }

        boolean exists() {
            return this.redirect.exists() && this.redirect.canRead();
        }
    }
}

