/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.IFileStorage;
import ch.endte.syncmatica.SyncmaticManager;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.mixin_actor.ActorClientPlayNetworkHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;

public class Syncmatica {
    public static final String VERSION = "0.3.11";
    public static final String MOD_ID = "syncmatica";
    private static final String SERVER_PATH = "." + File.separator + "syncmatics";
    private static final String CLIENT_PATH = "." + File.separator + "schematics" + File.separator + "sync";
    public static final class_2960 CLIENT_CONTEXT = new class_2960("syncmatica:client_context");
    public static final class_2960 SERVER_CONTEXT = new class_2960("syncmatica:server_context");
    public static final UUID syncmaticaId = UUID.fromString("4c1b738f-56fa-4011-8273-498c972424ea");
    private static Map<class_2960, Context> contexts = null;

    public static Context initServer(CommunicationManager comms, IFileStorage fileStorage, SyncmaticManager schematics, boolean isIntegratedServer, File worldPath) {
        Context serverContext = new Context(fileStorage, comms, schematics, true, new File(SERVER_PATH), isIntegratedServer, worldPath);
        Syncmatica.init(serverContext, SERVER_CONTEXT);
        return serverContext;
    }

    public static Context initClient(CommunicationManager comms, IFileStorage fileStorage, SyncmaticManager schematics) {
        Context clientContext = new Context(fileStorage, comms, schematics, new File(CLIENT_PATH));
        Syncmatica.init(clientContext, CLIENT_CONTEXT);
        return clientContext;
    }

    public static void restartClient() {
        Context oldClient = Syncmatica.getContext(CLIENT_CONTEXT);
        if (oldClient != null) {
            if (oldClient.isStarted()) {
                oldClient.shutdown();
            }
            contexts.remove(CLIENT_CONTEXT);
        }
        ActorClientPlayNetworkHandler.getInstance().startClient();
    }

    public static Context getContext(class_2960 id) {
        return contexts.get(id);
    }

    private static void init(Context con, class_2960 contextId) {
        if (contexts == null) {
            contexts = new HashMap<class_2960, Context>();
        }
        if (!contexts.containsKey(contextId)) {
            contexts.put(contextId, con);
        }
    }

    public static void shutdown() {
        if (contexts != null) {
            for (Context con : contexts.values()) {
                if (!con.isStarted()) continue;
                con.shutdown();
            }
        }
        Syncmatica.deinit();
    }

    private static void deinit() {
        contexts = null;
    }

    protected Syncmatica() {
    }
}

