/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.service;

import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.service.AbstractService;
import ch.endte.syncmatica.service.IServiceConfiguration;
import java.util.HashMap;
import java.util.Map;

public class QuotaService
extends AbstractService {
    public static final Boolean IS_ENABLED_DEFAULT = false;
    public static final Integer QUOTA_LIMIT_DEFAULT = 40000000;
    Map<String, Integer> progress = new HashMap<String, Integer>();
    Boolean isEnabled = IS_ENABLED_DEFAULT;
    Integer limit = QUOTA_LIMIT_DEFAULT;

    public Boolean isOverQuota(ExchangeTarget sender, Integer newData) {
        if (!Boolean.TRUE.equals(this.isEnabled)) {
            return false;
        }
        int curValue = this.progress.getOrDefault(sender.getPersistentName(), 0);
        return (curValue += newData.intValue()) > this.limit;
    }

    public void progressQuota(ExchangeTarget sender, Integer newData) {
        if (Boolean.TRUE.equals(this.isEnabled)) {
            int curValue = this.progress.getOrDefault(sender.getPersistentName(), 0);
            this.progress.put(sender.getPersistentName(), curValue + newData);
        }
    }

    @Override
    public void getDefaultConfiguration(IServiceConfiguration configuration) {
        configuration.saveBoolean("enabled", IS_ENABLED_DEFAULT);
        configuration.saveInteger("limit", QUOTA_LIMIT_DEFAULT);
    }

    @Override
    public String getConfigKey() {
        return "quota";
    }

    @Override
    public void configure(IServiceConfiguration configuration) {
        configuration.loadBoolean("enabled", b -> {
            this.isEnabled = b;
        });
        configuration.loadInteger("limit", i -> {
            this.limit = i;
        });
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }
}

