/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public abstract class ShapeBlocky
extends ShapeBase {
    private BlockSnap snap = BlockSnap.CENTER;
    protected class_238 renderPerimeter = ShapeBox.DEFAULT_BOX;
    private boolean combineQuads;

    public ShapeBlocky(ShapeType type, Color4f color) {
        super(type, color);
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
    }

    public boolean getCombineQuads() {
        return this.combineQuads;
    }

    public boolean toggleCombineQuads() {
        this.combineQuads = !this.combineQuads;
        this.setNeedsUpdate();
        return this.combineQuads;
    }

    protected void setRenderPerimeter(class_243 center, double range) {
        this.renderPerimeter = new class_238(center.field_1352 - range, center.field_1351 - range, center.field_1350 - range, center.field_1352 + range, center.field_1351 + range, center.field_1350 + range);
    }

    protected class_243 getBlockSnappedPosition(class_243 pos) {
        BlockSnap snap = this.getBlockSnap();
        if (snap == BlockSnap.CENTER) {
            return new class_243(Math.floor(pos.field_1352) + 0.5, Math.floor(pos.field_1351), Math.floor(pos.field_1350) + 0.5);
        }
        if (snap == BlockSnap.CORNER) {
            return new class_243(Math.floor(pos.field_1352), Math.floor(pos.field_1351), Math.floor(pos.field_1350));
        }
        return pos;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        class_1297 entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.method_1006(entity.method_19538());
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(class_293.class_5596.field_27382);
    }

    @Override
    public void draw(class_4587 matrixStack, Matrix4f projMatrix) {
        this.preRender();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.disableBlend();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableBlend();
        this.postRender();
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.block_snap", (Object[])new Object[]{snap.getDisplayName()}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("combine_quads", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.combineQuads)));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        this.combineQuads = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"combine_quads", (boolean)false);
    }

    protected Consumer<class_2338.class_2339> getPositionCollector(LongOpenHashSet positionsOut) {
        IntBoundingBox box = this.layerRange.getExpandedBox((class_1937)this.mc.field_1687, 0);
        Consumer<class_2338.class_2339> positionCollector = pos -> {
            if (box.containsPos((class_2382)pos)) {
                positionsOut.add(pos.method_10063());
            }
        };
        return positionCollector;
    }
}

