/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class RegistryHelperV2 {
    private RegistryHelperV2() {
    }

    public static <T> class_2378<T> findBuiltInRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        class_2378<T> registry = RegistryHelperV2.findNullableBuiltInRegistry(registryKey);
        Objects.requireNonNull(registry, "registry for %s is null".formatted(registryKey));
        return registry;
    }

    @Nullable
    public static <T> class_2378<T> findNullableBuiltInRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        return (class_2378)class_7923.field_41167.method_29107(registryKey);
    }

    public static <T> class_2378<T> findGameRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        class_2378<T> registry = RegistryHelperV2.findNullableGameRegistry(registryKey);
        Objects.requireNonNull(registry, "registry for %s is null".formatted(registryKey));
        return registry;
    }

    public static <T> class_2378<T> findNullableGameRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        Objects.requireNonNull(registryKey, "registry key is null");
        Optional<class_2378<T>> registry = Optional.empty();
        MinecraftServer minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer();
        if (minecraftServer != null) {
            registry = minecraftServer.method_30611().method_33310(registryKey);
        }
        if (registry.isEmpty()) {
            registry = Optional.ofNullable(RegistryHelperV2.findNullableBuiltInRegistry(registryKey));
        }
        return registry.orElse(null);
    }

    public static <T> Optional<class_5321<T>> getResourceKey(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelperV2.getHolderReference(registryKey, object).map(class_6880.class_6883::method_40237);
    }

    public static <T> Optional<class_5321<T>> getResourceKey(class_2378<T> registry, T object) {
        return RegistryHelperV2.getHolderReference(registry, object).map(class_6880.class_6883::method_40237);
    }

    public static <T> class_5321<T> getResourceKeyOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelperV2.getResourceKey(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + registryKey + ": " + object));
    }

    public static <T> class_5321<T> getResourceKeyOrThrow(class_2378<T> registry, T object) {
        return RegistryHelperV2.getResourceKey(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + registry.method_30517() + ": " + object));
    }

    public static <T> Optional<class_6880.class_6883<T>> getHolderReference(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return Optional.ofNullable(RegistryHelperV2.getBuiltInRegistryHolder(object)).or(() -> {
            class_2378 registry = RegistryHelperV2.findGameRegistry(registryKey);
            return registry.method_29113(object).flatMap(arg_0 -> registry.method_40264(arg_0));
        });
    }

    public static <T> Optional<class_6880.class_6883<T>> getHolderReference(class_2378<T> registry, T object) {
        return Optional.ofNullable(RegistryHelperV2.getBuiltInRegistryHolder(object)).or(() -> registry.method_29113(object).flatMap(arg_0 -> ((class_2378)registry).method_40264(arg_0)));
    }

    public static <T> class_6880.class_6883<T> getHolderOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelperV2.getHolderReference(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + registryKey + ": " + object));
    }

    public static <T> class_6880.class_6883<T> getHolderOrThrow(class_2378<T> registry, T object) {
        return RegistryHelperV2.getHolderReference(registry, object).orElseThrow(() -> new IllegalStateException("Missing object in " + registry.method_30517() + ": " + object));
    }

    public static <T> class_6880<T> wrapAsHolder(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelperV2.findGameRegistry(registryKey).method_47983(object);
    }

    public static <T> boolean is(class_6862<T> tagKey, T object) {
        class_6880.class_6883<T> holder = RegistryHelperV2.getBuiltInRegistryHolder(object);
        if (holder != null) {
            return holder.method_40220(tagKey);
        }
        class_2378<T> registry = RegistryHelperV2.findGameRegistry(tagKey.comp_326());
        return tagKey.method_41007(registry.method_30517()) && registry.method_47983(object).method_40220(tagKey);
    }

    @Nullable
    public static <T> class_6880.class_6883<T> getBuiltInRegistryHolder(T object) {
        class_6880.class_6883 holder = null;
        if (object instanceof class_2248) {
            class_2248 block = (class_2248)object;
            holder = block.method_40142();
        } else if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            holder = item.method_40131();
        } else if (object instanceof class_1299) {
            class_1299 entityType = (class_1299)object;
            holder = entityType.method_40124();
        } else if (object instanceof class_5712) {
            class_5712 gameEvent = (class_5712)object;
            holder = gameEvent.method_40157();
        } else if (object instanceof class_3611) {
            class_3611 fluid = (class_3611)object;
            holder = fluid.method_40178();
        } else if (object instanceof class_1887) {
            class_1887 enchantment = (class_1887)object;
            holder = enchantment.method_53216();
        } else if (object instanceof class_1291) {
            class_1291 mobEffect = (class_1291)object;
            holder = mobEffect.method_53123();
        } else if (object instanceof class_1842) {
            class_1842 potion = (class_1842)object;
            holder = potion.method_53211();
        } else if (object instanceof class_2591) {
            class_2591 blockEntityType = (class_2591)object;
            holder = blockEntityType.method_53254();
        }
        return holder;
    }
}

