/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.utils.resource;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kosmo.music.ClientMusic;
import net.kosmo.music.utils.resource.AlbumCover;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class MusicManager {
    private final class_3300 resourceManager;
    public Map<class_2960, Music> musics = Maps.newHashMap();

    public MusicManager(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void reload() {
        this.musics.clear();
        List resources = this.resourceManager.method_14489(ClientMusic.MUSICS_JSON_ID);
        for (class_3298 resource : resources) {
            try {
                for (Map.Entry entry : ClientMusic.parseJSONResource(resource).entrySet()) {
                    try {
                        Music m = Music.parseJsonObject(entry);
                        this.musics.put(m.identifier, m);
                    }
                    catch (Exception e) {
                        ClientMusic.LOGGER.error("Failed to parse music entry: {}\nMessage: {}", entry.getKey(), (Object)e.getMessage());
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                ClientMusic.LOGGER.error("Error when reading {} in resourcepack: '{}'\nMessage: {}", new Object[]{ClientMusic.MUSICS_JSON_ID, resource.method_14480(), e.getMessage()});
            }
        }
    }

    @Nullable
    public Music get(class_2960 id) {
        Music m = this.musics.get(id);
        if (m == null) {
            m = this.musics.get(new class_2960(id.method_12836(), id.method_12832().replace("records/", "music_disc.")));
        }
        return m;
    }

    public static class Music {
        public final class_2960 identifier;
        @Nullable
        public final class_2960 customId;
        public final String title;
        public final String author;
        @Nullable
        public final String album;
        public final AlbumCover albumCover;
        public final boolean isRandom;

        public Music(class_2960 identifier, @Nullable class_2960 customId, String title, String author, @Nullable String album, AlbumCover albumCover, boolean isRandom) {
            this.identifier = identifier;
            this.customId = customId;
            this.title = title;
            this.author = author;
            this.album = album;
            this.albumCover = albumCover;
            this.isRandom = isRandom;
        }

        public static Music parseJsonObject(Map.Entry<String, JsonElement> json) throws JsonSyntaxException {
            JsonObject jsonObject = json.getValue().getAsJsonObject();
            class_2960 identifier = new class_2960(json.getKey());
            String rawCustomId = class_3518.method_15253((JsonObject)jsonObject, (String)"customId", null);
            class_2960 customId = rawCustomId == null ? null : new class_2960(rawCustomId);
            String title = class_3518.method_15265((JsonObject)jsonObject, (String)"title");
            String author = class_3518.method_15265((JsonObject)jsonObject, (String)"author");
            String album = class_3518.method_15253((JsonObject)jsonObject, (String)"album", null);
            if (album == null) {
                album = class_3518.method_15265((JsonObject)jsonObject, (String)"soundtrack");
                ClientMusic.LOGGER.error("Key 'soundtrack' of '{}' is deprecated, use 'album' instead", (Object)title);
            }
            AlbumCover cover = AlbumCover.parseAlbumCover(class_3518.method_15253((JsonObject)jsonObject, (String)"cover", null));
            boolean isRandom = class_3518.method_15258((JsonObject)jsonObject, (String)"isRandom", (boolean)false);
            return new Music(identifier, customId, title, author, album, cover, isRandom);
        }

        public String toString() {
            return String.format("title: %s, author: %s, album: %s, cover: %s, identifier: %s, customId: %s, isRandom: %s", this.title, this.author, this.album, this.albumCover.textureId, this.identifier, this.customId, this.isRandom);
        }

        public String getTitle() {
            return this.title == null ? "Unknown" : this.title;
        }

        public String getAuthor() {
            return this.author == null ? "Unknown" : this.author;
        }

        public String getAlbumName() {
            return this.album == null ? "Unknown" : this.album;
        }

        public class_2960 getAlbumCoverTextureId() {
            if (this.albumCover.textureId != null) {
                return this.albumCover.textureId;
            }
            if (this.identifier != null && !Objects.equals(this.identifier.method_12836(), "minecraft")) {
                return AlbumCover.MODDED.textureId;
            }
            return AlbumCover.GENERIC.textureId;
        }

        @Nullable
        public class_3414 getSoundEvent(class_1144 soundManager) {
            class_2960 id;
            class_2960 class_29602 = id = this.customId == null ? this.identifier : this.customId;
            if (soundManager.method_4869(id) != null) {
                return class_3414.method_47908((class_2960)id);
            }
            return null;
        }
    }

    public static class Sound {
        public final class_2960 identifier;

        public Sound(class_2960 identifier) {
            this.identifier = identifier;
        }

        @Nullable
        public class_3414 getSoundEvent(class_1144 soundManager) {
            if (soundManager.method_4869(this.identifier) != null) {
                return class_3414.method_47908((class_2960)this.identifier);
            }
            return null;
        }
    }
}

