/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.metadata;

import io.github.moremcmeta.moremcmeta.api.math.NegativeDimensionException;
import org.jetbrains.annotations.ApiStatus;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.NonExtendable
public interface GuiScaling {
    public String name();

    public static final class NineSlice
    implements GuiScaling {
        private final int LEFT;
        private final int TOP;
        private final int RIGHT;
        private final int BOTTOM;

        public NineSlice(int left, int right, int top, int bottom) {
            if (left < 0) {
                throw new NegativeDimensionException(left);
            }
            if (right < 0) {
                throw new NegativeDimensionException(right);
            }
            if (top < 0) {
                throw new NegativeDimensionException(top);
            }
            if (bottom < 0) {
                throw new NegativeDimensionException(bottom);
            }
            this.LEFT = left;
            this.RIGHT = right;
            this.TOP = top;
            this.BOTTOM = bottom;
        }

        public int left() {
            return this.LEFT;
        }

        public int right() {
            return this.RIGHT;
        }

        public int top() {
            return this.TOP;
        }

        public int bottom() {
            return this.BOTTOM;
        }

        public boolean hasCenterSlice(int frameWidth, int frameHeight) {
            if (frameWidth < 0) {
                throw new NegativeDimensionException(frameWidth);
            }
            if (frameHeight < 0) {
                throw new NegativeDimensionException(frameHeight);
            }
            return this.left() + this.right() < frameWidth && this.top() + this.bottom() < frameHeight;
        }

        public boolean equals(Object other) {
            if (!(other instanceof NineSlice)) {
                return false;
            }
            NineSlice otherSlice = (NineSlice)other;
            return this.left() == otherSlice.left() && this.right() == otherSlice.right() && this.top() == otherSlice.top() && this.bottom() == otherSlice.bottom();
        }

        @Override
        public String name() {
            return "nine_slice";
        }
    }

    public static final class Tile
    implements GuiScaling {
        public boolean equals(Object other) {
            return other instanceof Tile;
        }

        @Override
        public String name() {
            return "tile";
        }
    }

    public static final class Stretch
    implements GuiScaling {
        public boolean equals(Object other) {
            return other instanceof Stretch;
        }

        @Override
        public String name() {
            return "stretch";
        }
    }
}

