/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableMap;
import io.github.moremcmeta.moremcmeta.impl.client.resource.OrderedResourceRepository;
import io.github.moremcmeta.moremcmeta.impl.client.resource.TextureLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_2960;

public final class TextureCache<R, S> {
    private final Lock LOCK = new ReentrantLock();
    private final Condition IS_CURRENT = this.LOCK.newCondition();
    private final TextureLoader<R> LOADER;
    private final Map<class_2960, R> CACHE = new HashMap<class_2960, R>();
    private S state;

    public TextureCache(TextureLoader<R> loader) {
        this.LOADER = Objects.requireNonNull(loader, "Loader cannot be null");
    }

    public void load(OrderedResourceRepository repository, S newState, String ... paths) {
        Objects.requireNonNull(repository, "Repository cannot be null");
        Objects.requireNonNull(paths, "Paths cannot be null");
        Objects.requireNonNull(newState, "State cannot be null");
        this.LOCK.lock();
        if (!newState.equals(this.state)) {
            this.CACHE.clear();
            this.state = newState;
            ImmutableMap<class_2960, R> previousResults = this.LOADER.load(repository, paths);
            this.CACHE.putAll((Map<class_2960, R>)previousResults);
            this.IS_CURRENT.signalAll();
        }
        this.LOCK.unlock();
    }

    public ImmutableMap<class_2960, R> get(S newState) {
        Objects.requireNonNull(newState, "State cannot be null");
        this.LOCK.lock();
        while (!newState.equals(this.state)) {
            this.IS_CURRENT.awaitUninterruptibly();
        }
        ImmutableMap cacheCopy = ImmutableMap.copyOf(this.CACHE);
        this.LOCK.unlock();
        return cacheCopy;
    }
}

