/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.core.networking.PacketRegistry;
import com.hypherionmc.craterlib.core.networking.data.PacketContext;
import com.hypherionmc.craterlib.core.networking.data.PacketHolder;
import com.hypherionmc.craterlib.core.networking.data.PacketSide;
import com.hypherionmc.craterlib.nojang.network.BridgedFriendlyByteBuf;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CraterFabricNetworkHandler
extends PacketRegistry {
    private final Map<Class<?>, Message<?>> CHANNELS = new HashMap();

    public CraterFabricNetworkHandler(PacketSide side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketHolder<T> holder) {
        if (this.CHANNELS.get(holder.messageType()) == null) {
            this.CHANNELS.put(holder.messageType(), new Message<T>(holder.type(), holder.encoder()));
            if (PacketSide.CLIENT.equals((Object)this.side)) {
                ClientPlayNetworking.registerGlobalReceiver((class_2960)holder.type().toMojang(), (client, listener, buf, responseSender) -> {
                    buf.readByte();
                    Object message = holder.decoder().apply(BridgedFriendlyByteBuf.of(buf));
                    client.execute(() -> holder.handler().accept(new PacketContext<Object>(message, PacketSide.CLIENT)));
                });
            } else {
                ServerPlayNetworking.registerGlobalReceiver((class_2960)holder.type().toMojang(), (server, player, listener, buf, responseSender) -> {
                    buf.readByte();
                    Object message = holder.decoder().apply(BridgedFriendlyByteBuf.of(buf));
                    server.execute(() -> holder.handler().accept(new PacketContext<Object>(BridgedPlayer.of((class_1657)player), message, PacketSide.SERVER)));
                });
            }
        } else {
            CraterConstants.LOG.error("Trying to register duplicate packet for type {}", holder.messageType());
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (ClientPlayNetworking.canSend((class_2960)message.id().toMojang()) || ignoreCheck) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_52997(0);
            message.encoder().accept(packet, BridgedFriendlyByteBuf.of(buf));
            ClientPlayNetworking.send((class_2960)message.id().toMojang(), (class_2540)buf);
        }
    }

    @Override
    public <T> void sendToClient(T packet, BridgedPlayer player) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (ServerPlayNetworking.canSend((class_3222)player.toMojangServerPlayer(), (class_2960)message.id().toMojang())) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_52997(0);
            message.encoder().accept(packet, BridgedFriendlyByteBuf.of(buf));
            ServerPlayNetworking.send((class_3222)player.toMojangServerPlayer(), (class_2960)message.id().toMojang(), (class_2540)buf);
        }
    }

    public record Message<T>(ResourceIdentifier id, BiConsumer<T, BridgedFriendlyByteBuf> encoder) {
    }
}

