/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import team.creative.ambientsounds.AmbientTickHandler;

public class AmbientVolume
implements Comparable<AmbientVolume> {
    public static final AmbientVolume SILENT = new AmbientVolume(0.0, 0.0){

        @Override
        public void mulCondition(double volume) {
        }

        @Override
        public void mulSetting(double volume) {
        }
    };
    public static final AmbientVolume MAX = new AmbientVolume(1.0, 1.0){

        @Override
        public void mulCondition(double volume) {
        }

        @Override
        public void mulSetting(double volume) {
        }
    };
    private double conditionVolume;
    private double settingVolume;

    public AmbientVolume(double conditionVolume, double settingVolume) {
        this.conditionVolume = conditionVolume;
        this.settingVolume = settingVolume;
    }

    public AmbientVolume() {
        this(1.0, 1.0);
    }

    @Deprecated
    public void setConditionVolumeDirect(double volume) {
        this.conditionVolume = volume;
    }

    public void mulVolume(AmbientVolume selection) {
        this.mulCondition(selection.conditionVolume());
        this.mulSetting(selection.settingVolume());
    }

    public void mulCondition(double volume) {
        this.conditionVolume *= volume;
    }

    public void mulSetting(double volume) {
        this.settingVolume *= volume;
    }

    public double conditionVolume() {
        return this.conditionVolume;
    }

    public double settingVolume() {
        return this.settingVolume;
    }

    public double volume() {
        return this.settingVolume * this.conditionVolume;
    }

    @Override
    public int compareTo(AmbientVolume o) {
        return Double.compare(this.volume(), o.volume());
    }

    public String toString() {
        return AmbientTickHandler.DECIMAL_FORMAT.format(this.volume()) + "(" + AmbientTickHandler.DECIMAL_FORMAT.format(this.conditionVolume()) + ")";
    }

    public AmbientVolume copy() {
        return new AmbientVolume(this.conditionVolume, this.settingVolume);
    }
}

