/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.TargetsHelper;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_6880;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<class_4763.class_5486> grassColorModifier, Optional<class_4761> ambientParticleSettings, Optional<class_6880<class_3414>> ambientLoopSoundEvent, Optional<class_4968> ambientMoodSettings, Optional<class_4967> ambientAdditionsSettings, Optional<class_5195> backgroundMusic, Optional<Set<class_2960>> explicitTargets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.INT, "fog_color").forGetter(BiomeEffectModifier::fogColor), (App)StrOpt.of(Codec.INT, "water_color").forGetter(BiomeEffectModifier::waterColor), (App)StrOpt.of(Codec.INT, "water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)StrOpt.of(Codec.INT, "sky_color").forGetter(BiomeEffectModifier::skyColor), (App)StrOpt.of(Codec.INT, "foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)StrOpt.of(Codec.INT, "grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)StrOpt.of(class_4763.class_5486.field_26429, "grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)StrOpt.of(class_4761.field_24675, "particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)StrOpt.of(class_3414.field_41699, "ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)StrOpt.of(class_4968.field_24674, "mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)StrOpt.of(class_4967.field_24673, "additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)StrOpt.of(class_5195.field_24627, "music").forGetter(BiomeEffectModifier::backgroundMusic), (App)StrOpt.of(TargetsHelper.CODEC, "targets").forGetter(BiomeEffectModifier::explicitTargets)).apply((Applicative)instance, BiomeEffectModifier::new));

    public static BiomeEffectModifier ofWaterColor(int waterColor) {
        return new BiomeEffectModifier(Optional.empty(), Optional.of(waterColor), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public BiomeEffectModifier merge(BiomeEffectModifier other) {
        return new BiomeEffectModifier(other.fogColor.isPresent() ? other.fogColor() : this.fogColor(), other.waterColor().isPresent() ? other.waterColor() : this.waterColor(), other.waterFogColor().isPresent() ? other.waterFogColor() : this.waterFogColor(), other.skyColor().isPresent() ? other.skyColor() : this.skyColor(), other.foliageColorOverride().isPresent() ? other.waterColor() : this.foliageColorOverride(), other.grassColorOverride().isPresent() ? other.grassColorOverride() : this.grassColorOverride(), other.grassColorModifier().isPresent() ? other.grassColorModifier() : this.grassColorModifier(), other.ambientParticleSettings().isPresent() ? other.ambientParticleSettings() : this.ambientParticleSettings(), other.ambientLoopSoundEvent().isPresent() ? other.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), other.ambientMoodSettings().isPresent() ? other.ambientMoodSettings() : this.ambientMoodSettings(), other.ambientAdditionsSettings().isPresent() ? other.ambientAdditionsSettings() : this.ambientAdditionsSettings(), other.backgroundMusic().isPresent() ? other.backgroundMusic() : this.backgroundMusic(), TargetsHelper.merge(other.explicitTargets, this.explicitTargets));
    }

    public class_4763 apply(class_1959 biome) {
        class_4763 effects = biome.method_24377();
        class_4763.class_4764 builder = new class_4763.class_4764();
        int newFog = effects.method_24387();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.method_24392(newFog);
        int newWaterColor = effects.method_24388();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.method_24395(newWaterColor);
        int newWaterFogColor = effects.method_24389();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.method_24397(newWaterFogColor);
        int newSkyColor = effects.method_30810();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.method_30820(newSkyColor);
        Optional<Integer> newFoliageColorOverride = effects.method_30811();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        Optional<Integer> newGrassColorOverride = effects.method_30812();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        class_4763.class_5486 newGrassColorModifier = effects.method_30814();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.method_30818(newGrassColorModifier);
        Optional<class_4761> newParticle = effects.method_24390();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24393(arg_0));
        Optional<class_6880<class_3414>> newAmbientSound = effects.method_24939();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24942(arg_0));
        Optional<class_4968> newMood = effects.method_24940();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24943(arg_0));
        Optional<class_4967> newAdditions = effects.method_24941();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24944(arg_0));
        Optional<class_5195> newMusic = effects.method_27345();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_27346(arg_0));
        class_4763 copy = this.copy(effects);
        BiomeEffectModifier.applyInplace(biome, builder.method_24391());
        return copy;
    }

    private class_4763 copy(class_4763 effects) {
        class_4763.class_4764 builder = new class_4763.class_4764();
        builder.method_24392(effects.method_24387());
        builder.method_24395(effects.method_24388());
        builder.method_24397(effects.method_24389());
        builder.method_30820(effects.method_30810());
        effects.method_30811().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        effects.method_30812().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        builder.method_30818(effects.method_30814());
        effects.method_24390().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24393(arg_0));
        effects.method_24939().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24942(arg_0));
        effects.method_24940().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24943(arg_0));
        effects.method_24941().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_24944(arg_0));
        effects.method_27345().ifPresent(arg_0 -> ((class_4763.class_4764)builder).method_27346(arg_0));
        return builder.method_24391();
    }

    public static void applyInplace(class_1959 biome, class_4763 newEffects) {
        class_4763 oldEffects = biome.method_24377();
        oldEffects.field_22067 = newEffects.method_24387();
        oldEffects.field_22068 = newEffects.method_24388();
        oldEffects.field_22069 = newEffects.method_24389();
        oldEffects.field_26418 = newEffects.method_30810();
        oldEffects.field_26419 = newEffects.method_30811();
        oldEffects.field_26420 = newEffects.method_30812();
        oldEffects.field_26421 = newEffects.method_30814();
        oldEffects.field_22070 = newEffects.method_24390();
        oldEffects.field_22491 = newEffects.method_24939();
        oldEffects.field_22492 = newEffects.method_24940();
        oldEffects.field_22493 = newEffects.method_24941();
        oldEffects.field_24113 = newEffects.method_27345();
    }
}

