/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.fluid.fabric.FluidPropertiesManagerImpl;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<class_3611, FluidPropertyModifier> modifiers = new HashMap<class_3611, FluidPropertyModifier>();
    private Map<class_2960, FluidPropertyModifier> extraModifiers;
    private Map<class_2960, ArrayImage> extraImages;

    public FluidPropertiesManager() {
        super("fluid_properties");
    }

    public void addConvertedBlockProperties(Map<class_2960, BlockPropertyModifier> modifiers, Map<class_2960, ArrayImage> textures) {
        this.extraImages = textures;
        this.extraModifiers = new HashMap<class_2960, FluidPropertyModifier>();
        for (Map.Entry<class_2960, BlockPropertyModifier> v : modifiers.entrySet()) {
            BlockPropertyModifier m = v.getValue();
            Optional<class_322> c = m.tintGetter();
            if (!c.isPresent()) continue;
            this.extraModifiers.put(v.getKey(), new FluidPropertyModifier(c, Optional.empty(), m.explicitTargets()));
        }
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(class_3300 resourceManager) {
        HashMap<class_2960, JsonElement> jsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)this.path(), (Gson)GSON, jsons);
        FluidPropertiesManager.checkConditions(jsons);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.gatherImages(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(ArrayImage.gatherImages(resourceManager, this.path()));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage> textures = resources.textures();
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, FluidPropertyModifier> parsedModifiers = new HashMap<class_2960, FluidPropertyModifier>(this.extraModifiers);
        textures.putAll(this.extraImages);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)((Pair)FluidPropertyModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Fluid Color Modifier with json id {} - error: {}", (Object)id2, errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate fluid modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (class_2960)entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)entry.getValue();
            class_322 colormap = modifier.colormap().orElse(null);
            if (colormap instanceof Colormap) {
                Colormap c = (Colormap)colormap;
                ArrayImage text = textures.get(c.getTargetTexture() == null ? id : c.getTargetTexture());
                if (text != null) {
                    ColormapsManager.tryAcceptingTexture(text, id, c, usedTextures);
                } else if (c.getTargetTexture() != null) {
                    Polytone.LOGGER.error("Could not resolve explicit texture for colormap {} from fluid modifier {}. Skipping", (Object)c.getTargetTexture(), (Object)id);
                    continue;
                }
            }
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            Colormap defaultColormap = Colormap.defTriangle();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, defaultColormap, usedTextures);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Optional.empty()));
        }
    }

    @Override
    protected void reset() {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
    }

    private void addModifier(class_2960 pathId, FluidPropertyModifier mod) {
        Optional<Set<class_2960>> explTargets = mod.explicitTargets();
        Optional implicitTarget = class_7923.field_41173.method_17966(pathId);
        if (explTargets.isPresent() && !explTargets.get().isEmpty()) {
            if (implicitTarget.isPresent() && !explTargets.get().contains(pathId)) {
                Polytone.LOGGER.error("Found Fluid Properties Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)pathId);
            }
            for (class_2960 explicitId : explTargets.get()) {
                Optional target = class_7923.field_41173.method_17966(explicitId);
                target.ifPresent(fluid -> this.modifiers.merge((class_3611)fluid, mod, FluidPropertyModifier::merge));
                FluidPropertiesManager.tryAddSpecial(explicitId, mod);
            }
        } else {
            implicitTarget.ifPresent(fluid -> this.modifiers.merge((class_3611)fluid, mod, FluidPropertyModifier::merge));
            FluidPropertiesManager.tryAddSpecial(pathId, mod);
            if (implicitTarget.isEmpty() && PlatStuff.isModLoaded(pathId.method_12836())) {
                Polytone.LOGGER.error("Found Fluid Properties Modifier with no implicit target ({}) and no explicit targets", (Object)pathId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(class_2960 id, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(id, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public FluidPropertyModifier getModifier(class_3611 water) {
        return this.modifiers.get(water);
    }
}

