/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.gui.controllers.LabelController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LabelOptionImpl
implements LabelOption {
    private final class_2561 label;
    private final class_2561 name = class_2561.method_43470((String)"Label Option");
    private final OptionDescription description;
    private final class_2561 tooltip = class_2561.method_43473();
    private final LabelController labelController;
    private final Binding<class_2561> binding;

    public LabelOptionImpl(class_2561 label) {
        Validate.notNull((Object)label, (String)"`label` must not be null", (Object[])new Object[0]);
        this.label = label;
        this.labelController = new LabelController(this);
        this.binding = Binding.immutable(label);
        this.description = OptionDescription.createBuilder().text(this.label).build();
    }

    @Override
    @NotNull
    public class_2561 label() {
        return this.label;
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public Controller<class_2561> controller() {
        return this.labelController;
    }

    @Override
    @NotNull
    public Binding<class_2561> binding() {
        return this.binding;
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public void setAvailable(boolean available) {
        throw new UnsupportedOperationException("Label options cannot be disabled.");
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return ImmutableSet.of();
    }

    @Override
    public boolean changed() {
        return false;
    }

    @Override
    @NotNull
    public class_2561 pendingValue() {
        return this.label;
    }

    @Override
    public void requestSet(@NotNull class_2561 value) {
    }

    @Override
    public boolean applyValue() {
        return false;
    }

    @Override
    public void forgetPendingValue() {
    }

    @Override
    public void requestSetDefault() {
    }

    @Override
    public boolean isPendingValueDefault() {
        return true;
    }

    @Override
    public boolean canResetToDefault() {
        return false;
    }

    @Override
    public void addListener(BiConsumer<Option<class_2561>, class_2561> changedListener) {
    }

    @ApiStatus.Internal
    public static final class BuilderImpl
    implements LabelOption.Builder {
        private final List<class_2561> lines = new ArrayList<class_2561>();

        @Override
        public LabelOption.Builder line(@NotNull class_2561 line) {
            Validate.notNull((Object)line, (String)"`line` must not be null", (Object[])new Object[0]);
            this.lines.add(line);
            return this;
        }

        @Override
        public LabelOption.Builder lines(@NotNull Collection<? extends class_2561> lines) {
            this.lines.addAll(lines);
            return this;
        }

        @Override
        public LabelOption build() {
            class_5250 text = class_2561.method_43473();
            Iterator<class_2561> iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                text.method_10852(iterator.next());
                if (!iterator.hasNext()) continue;
                text.method_27693("\n");
            }
            return new LabelOptionImpl((class_2561)text);
        }
    }
}

