/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.EntitySelector;
import eu.ha3.presencefootsteps.config.JsonFile;
import eu.ha3.presencefootsteps.config.VolumeOption;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import java.nio.file.Path;
import net.minecraft.class_129;
import net.minecraft.class_3532;

public class PFConfig
extends JsonFile {
    private int volume = 70;
    public VolumeOption clientPlayerVolume = new VolumeOption(this, 100);
    public VolumeOption otherPlayerVolume = new VolumeOption(this, 100);
    public VolumeOption hostileEntitiesVolume = new VolumeOption(this, 100);
    public VolumeOption passiveEntitiesVolume = new VolumeOption(this, 100);
    public int runningVolumeIncrease = 0;
    public VolumeOption wetSoundsVolume = new VolumeOption(this, 50);
    public VolumeOption foliageSoundsVolume = new VolumeOption(this, 100);
    private int maxSteppingEntities = 50;
    private boolean disabled = false;
    private boolean firstRun = true;
    private boolean multiplayer = true;
    private boolean global = true;
    private boolean footwear = true;
    private boolean visualiser = false;
    private boolean exclusive = false;
    private Locomotion stance = Locomotion.NONE;
    private EntitySelector targetEntities = EntitySelector.ALL;
    private final transient PresenceFootsteps pf;

    public PFConfig(Path file, PresenceFootsteps pf) {
        super(file);
        this.pf = pf;
    }

    public boolean toggleMultiplayer() {
        this.multiplayer = !this.multiplayer;
        this.save();
        return this.multiplayer;
    }

    public EntitySelector cycleTargetSelector() {
        this.targetEntities = EntitySelector.VALUES[(this.getEntitySelector().ordinal() + 1) % EntitySelector.VALUES.length];
        this.save();
        return this.targetEntities;
    }

    public Locomotion setLocomotion(Locomotion loco) {
        if (loco != this.getLocomotion()) {
            this.stance = loco;
            this.save();
            this.pf.getEngine().reload();
        }
        return loco;
    }

    public boolean isVisualiserRunning() {
        return this.visualiser;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public void setNotFirstRun() {
        this.firstRun = false;
        this.save();
    }

    public Locomotion getLocomotion() {
        return this.stance == null ? Locomotion.NONE : this.stance;
    }

    public EntitySelector getEntitySelector() {
        return this.targetEntities == null ? EntitySelector.ALL : this.targetEntities;
    }

    public boolean getEnabledFootwear() {
        return this.footwear;
    }

    public boolean toggleFootwear() {
        this.footwear = !this.footwear;
        this.save();
        return this.footwear;
    }

    public boolean isExclusiveMode() {
        return this.exclusive;
    }

    public boolean toggleExclusiveMode() {
        this.exclusive = !this.exclusive;
        this.save();
        return this.exclusive;
    }

    public boolean getEnabledMP() {
        return this.multiplayer;
    }

    public int getMaxSteppingEntities() {
        return Math.max(1, this.maxSteppingEntities);
    }

    public boolean toggleDisabled() {
        this.disabled = !this.disabled;
        this.save();
        this.pf.onEnabledStateChange(!this.disabled);
        return this.disabled;
    }

    public boolean setDisabled(boolean disabled) {
        if (disabled != this.disabled) {
            this.toggleDisabled();
        }
        return disabled;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public boolean getEnabled() {
        return !this.disabled && this.getGlobalVolume() > 0;
    }

    public int getGlobalVolume() {
        return class_3532.method_15340((int)this.volume, (int)0, (int)100);
    }

    public int getRunningVolumeIncrease() {
        return class_3532.method_15340((int)this.runningVolumeIncrease, (int)-100, (int)100);
    }

    public float setGlobalVolume(float volume) {
        if ((float)this.volume != (volume = (float)PFConfig.volumeScaleToInt(volume))) {
            boolean wasEnabled = this.getEnabled();
            this.volume = (int)volume;
            this.save();
            if (this.getEnabled() != wasEnabled) {
                this.pf.onEnabledStateChange(this.getEnabled());
            }
        }
        return this.getGlobalVolume();
    }

    public float setRunningVolumeIncrease(float volume) {
        this.runningVolumeIncrease = volume > 97.0f ? 100 : (volume < -97.0f ? -100 : (int)volume);
        this.save();
        return this.getRunningVolumeIncrease();
    }

    public void populateCrashReport(class_129 section) {
        section.method_578("Disabled", (Object)this.getDisabled());
        section.method_578("Global Volume", (Object)this.volume);
        section.method_578("User's Selected Stance", (Object)this.getLocomotion());
        section.method_578("Target Selector", (Object)this.getEntitySelector());
        section.method_578("Enabled Global", (Object)this.global);
        section.method_578("Enabled Multiplayer", (Object)this.multiplayer);
    }

    private static int volumeScaleToInt(float volume) {
        return volume > 97.0f ? 100 : (volume < 3.0f ? 0 : (int)volume);
    }
}

