/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.Range;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public record AcousticsFile(Range defaultVolume, Range defaultPitch, String soundRoot) {
    private static final int ENGINE_VERSION = 2;

    @Nullable
    public static AcousticsFile read(Reader reader, BiConsumer<String, Acoustic> consumer, boolean ignoreVersion) {
        try {
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            AcousticsFile context = AcousticsFile.read(json, ignoreVersion);
            json.getAsJsonObject("contents").entrySet().forEach(element -> consumer.accept((String)element.getKey(), Acoustic.read(context, (JsonElement)element.getValue(), "events")));
            return context;
        }
        catch (JsonParseException e) {
            PresenceFootsteps.logger.error("Error whilst loading acoustics", (Throwable)e);
            return null;
        }
    }

    private static AcousticsFile read(JsonObject json, boolean ignoreVersion) {
        AcousticsFile.expect("library".equals(json.get("type").getAsString()), "Invalid type: Expected \"library\" got \"" + json.get("type").getAsString() + "\"");
        AcousticsFile.expect(ignoreVersion || json.get("engineversion").getAsInt() == 2, "Unrecognised Engine version: 2 expected, got " + json.get("engineversion").getAsInt());
        AcousticsFile.expect(json.has("contents"), "Empty contents");
        String soundRoot = "";
        if (json.has("soundroot")) {
            soundRoot = json.get("soundroot").getAsString();
        }
        if (json.has("defaults")) {
            JsonObject defaults = json.getAsJsonObject("defaults");
            return new AcousticsFile(Range.DEFAULT.read("volume", defaults), Range.DEFAULT.read("pitch", defaults), soundRoot);
        }
        return new AcousticsFile(Range.DEFAULT, Range.DEFAULT, soundRoot);
    }

    public void write(JsonObjectWriter writer, Map<String, Acoustic> acoustics) throws IOException {
        writer.object(() -> {
            writer.field("type", "library");
            writer.field("engineversion", 2);
            writer.object("defaults", () -> {
                writer.field("volume", () -> this.defaultVolume.write(writer));
                writer.field("pitch", () -> this.defaultPitch.write(writer));
            });
            if (!Strings.isNullOrEmpty((String)this.soundRoot)) {
                writer.field("soundroot", this.soundRoot);
            }
            writer.object("contents", () -> writer.each(acoustics.entrySet(), pair -> writer.field((String)pair.getKey(), () -> ((Acoustic)pair.getValue()).write(this, writer))));
        });
    }

    private static void expect(boolean condition, String message) {
        if (!condition) {
            throw new JsonParseException(message);
        }
    }

    public String getSoundName(String soundName) {
        if (soundName.charAt(0) != '@') {
            return this.soundRoot + soundName;
        }
        return soundName.replace("@", "");
    }
}

