/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class DisplayEntry {
    public static final int ENTRY_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    private final class_1814 rarity;
    private int remainingTicks;
    private int displayAmount;
    private class_2561 component;

    protected DisplayEntry(int displayAmount, class_1814 rarity) {
        this.displayAmount = displayAmount;
        this.rarity = rarity;
        this.resetEntry();
    }

    private static class_5250 wrapInBrackets(class_2561 toWrap) {
        return class_2561.method_43470((String)"(").method_10852(toWrap).method_27693(")");
    }

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract class_2561 getEntryName();

    protected abstract int getInventoryCount(class_1661 var1);

    public class_2561 getTextComponent(class_1657 player) {
        if (this.component == null) {
            int displayAmount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.text() ? this.getDisplayAmount() : 0;
            int inventoryCount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount ? this.getInventoryCount(player.method_31548()) : 0;
            this.component = class_2561.method_43473().method_10852(this.createTextComponent(this.getEntryName(), displayAmount, inventoryCount, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored())).method_10862(this.getComponentStyle());
        }
        return this.component;
    }

    private class_2561 createTextComponent(class_2561 name, int displayAmount, int inventoryCount, boolean reverse) {
        ArrayList components = Lists.newArrayList();
        if (inventoryCount > 0) {
            components.add(DisplayEntry.wrapInBrackets((class_2561)class_2561.method_43470((String)String.valueOf(inventoryCount))));
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayItemName) {
            components.add(name);
        }
        if (displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            components.add(class_2561.method_43470((String)(reverse ? displayAmount + "x" : "x" + displayAmount)));
        }
        if (reverse) {
            Collections.reverse(components);
        }
        return (class_2561)components.stream().reduce((component1, component2) -> class_2561.method_43473().method_10852(component1).method_27693(" ").method_10852(component2)).orElse(class_2561.method_43473());
    }

    private class_2583 getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && this.rarity != class_1814.field_8906) {
            return class_2583.field_24360.method_10977(this.rarity.field_8908);
        }
        return class_2583.field_24360.method_10977(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveTime, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        return 1.0f - class_3532.method_15363((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void resetEntry() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.component = null;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1, boolean var2);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount += other.displayAmount;
        this.resetEntry();
    }

    public int getEntryWidth(class_310 minecraft) {
        int textWidth = minecraft.field_1772.method_27525((class_5348)this.getTextComponent((class_1657)minecraft.field_1724));
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + (textWidth == 0 ? 0 : 4) + 16 : textWidth;
    }

    public void render(class_310 minecraft, class_332 guiGraphics, int posX, int posY, float alpha, float scale) {
        int fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int textStartX = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        this.renderBg(minecraft, guiGraphics, posX, posY, alpha);
        int n = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_51439(minecraft.field_1772, this.getTextComponent((class_1657)minecraft.field_1724), textStartX, posY + 4, 0xFFFFFF | fadeTime << 24, true);
            if (withSprite) {
                int textWidth = minecraft.field_1772.method_27525((class_5348)this.getTextComponent((class_1657)minecraft.field_1724));
                this.renderSprite(minecraft, guiGraphics, mirrorPosition ? posX + textWidth + (textWidth == 0 ? 0 : 4) : posX, posY, scale, (float)fadeTime / 255.0f);
            }
            RenderSystem.disableBlend();
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderBg(class_310 minecraft, class_332 guiGraphics, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.entryBackground) {
            case CHAT: {
                int backgroundOpacity = (int)((Double)minecraft.field_1690.method_42550().method_41753() * (double)(1.0f - alpha) * 255.0) << 24 & 0xFF000000;
                int endY = posY + 16;
                if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.sprite()) {
                    ++endY;
                }
                guiGraphics.method_25294(posX - 3, posY, posX + this.getEntryWidth(minecraft) + 5, endY, backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipInternal(guiGraphics, posX, posY + 3, this.getEntryWidth(minecraft), 9, (int)((1.0f - alpha) * 255.0f));
            }
        }
    }

    protected abstract void renderSprite(class_310 var1, class_332 var2, int var3, int var4, float var5, float var6);
}

