/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.util.RandomIndexProvider;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3300;

public class RandomCtmProperties
extends BaseCtmProperties {
    protected RandomIndexProvider.Factory indexProviderFactory = RandomIndexProvider.UnweightedFactory.INSTANCE;
    protected int randomLoops = 0;
    protected Symmetry symmetry = Symmetry.NONE;
    protected boolean linked = false;

    public RandomCtmProperties(Properties properties, class_2960 resourceId, class_3262 pack, int packPriority, class_3300 resourceManager, String method) {
        super(properties, resourceId, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseWeights();
        this.parseRandomLoops();
        this.parseSymmetry();
        this.parseLinked();
    }

    protected void parseWeights() {
        String weightsStr = this.properties.getProperty("weights");
        if (weightsStr == null) {
            return;
        }
        String[] weightStrs = weightsStr.trim().split("[ ,]");
        if (weightStrs.length != 0) {
            IntArrayList weights = new IntArrayList();
            for (int i = 0; i < weightStrs.length; ++i) {
                String weightStr;
                block9: {
                    weightStr = weightStrs[i];
                    if (weightStr.isEmpty()) continue;
                    String[] parts = weightStr.split("-", 2);
                    try {
                        int weight;
                        if (parts.length == 2) {
                            int min = Integer.parseInt(parts[0]);
                            int max = Integer.parseInt(parts[1]);
                            if (min <= 0 || max <= 0 || max < min) break block9;
                            for (int weight2 = min; weight2 <= max; ++weight2) {
                                weights.add(weight2);
                            }
                            continue;
                        }
                        if (parts.length == 1 && (weight = Integer.parseInt(parts[0])) > 0) {
                            weights.add(weight);
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'weights' element '" + weightStr + "' at index '" + i + "' in file '" + this.resourceId + "' in pack '" + this.packName + "'");
            }
            if (!weights.isEmpty()) {
                this.indexProviderFactory = new RandomIndexProvider.WeightedFactory(weights.toIntArray());
            }
        }
    }

    protected void parseRandomLoops() {
        String randomLoopsStr = this.properties.getProperty("randomLoops");
        if (randomLoopsStr == null) {
            return;
        }
        try {
            int randomLoops = Integer.parseInt(randomLoopsStr.trim());
            if (randomLoops >= 0 && randomLoops <= 9) {
                this.randomLoops = randomLoops;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ContinuityClient.LOGGER.warn("Invalid 'randomLoops' value '" + randomLoopsStr + "' in file '" + this.resourceId + "' in pack '" + this.packName + "'");
    }

    protected void parseSymmetry() {
        Symmetry symmetry = PropertiesParsingHelper.parseSymmetry(this.properties, "symmetry", this.resourceId, this.packName);
        if (symmetry != null) {
            this.symmetry = symmetry;
        }
    }

    protected void parseLinked() {
        String linkedStr = this.properties.getProperty("linked");
        if (linkedStr == null) {
            return;
        }
        this.linked = Boolean.parseBoolean(linkedStr.trim());
    }

    public RandomIndexProvider.Factory getIndexProviderFactory() {
        return this.indexProviderFactory;
    }

    public int getRandomLoops() {
        return this.randomLoops;
    }

    public Symmetry getSymmetry() {
        return this.symmetry;
    }

    public boolean getLinked() {
        return this.linked;
    }
}

