/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerMacOsUtils;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class ScreenshotViewerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static final Clipboard AWT_CLIPBOARD = ScreenshotViewerUtils.tryGetAWTClipboard();
    private static final class_370.class_9037 COPY_SCREENSHOT = new class_370.class_9037(3000L);
    private static Method DRAW_TOOLTIP;
    private static boolean errorLogged;

    public static File getVanillaScreenshotsFolder() {
        return new File(class_310.method_1551().field_1697, "screenshots");
    }

    public static void drawTexture(class_332 context, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        int x2 = x + width;
        int y2 = y + height;
        float u1 = (float)u / (float)textureWidth;
        float u2 = ((float)u + (float)regionWidth) / (float)textureWidth;
        float v1 = (float)v / (float)textureHeight;
        float v2 = ((float)v + (float)regionHeight) / (float)textureHeight;
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y2, 0.0f).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y, 0.0f).method_22913(u2, v1).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    @Nullable
    private static Clipboard tryGetAWTClipboard() {
        if (class_310.field_1703) {
            return null;
        }
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable t) {
            LOGGER.error("Unable to retrieve Java AWT Clipboard instance!", t);
            return null;
        }
    }

    public static void copyImageToClipboard(File screenshotFile) {
        if (class_310.field_1703) {
            ScreenshotViewerMacOsUtils.doCopyMacOS(screenshotFile.getAbsolutePath());
            return;
        }
        if (AWT_CLIPBOARD != null && screenshotFile.exists()) {
            CompletableFuture.runAsync(() -> {
                class_5250 toastText;
                try {
                    BufferedImage img = ImageIO.read(screenshotFile);
                    BufferedImage rgbImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                    rgbImg.createGraphics().drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
                    ImageTransferable imageTransferable = new ImageTransferable(rgbImg);
                    AWT_CLIPBOARD.setContents(imageTransferable, null);
                    toastText = ScreenshotViewerTexts.TOAST_COPY_SUCCESS;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to copy screenshot image to clipboard!", t);
                    toastText = ScreenshotViewerTexts.translatable("toast", "copy_fail", t.getClass().getSimpleName());
                }
                class_310 client = class_310.method_1551();
                if (client != null) {
                    class_370.method_1990((class_374)client.method_1566(), (class_370.class_9037)COPY_SCREENSHOT, (class_2561)toastText, (class_2561)class_2561.method_43470((String)screenshotFile.getName()));
                }
            }, class_156.method_18349());
        }
    }

    public static List<class_5684> toColoredComponents(class_310 client, class_2561 text) {
        return class_7919.method_47406((class_310)client, (class_2561)text).stream().map(ColoredTooltipComponent::new).collect(Collectors.toList());
    }

    public static void renderTooltip(class_332 context, class_327 textRenderer, List<class_5684> tooltipComponents, int posX, int posY) {
        block6: {
            if (DRAW_TOOLTIP == null) {
                try {
                    MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
                    String methodName = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_332", "method_51435", "(Lnet/minecraft/class_327;Ljava/util/List;IILnet/minecraft/class_8000;)V");
                    DRAW_TOOLTIP = class_332.class.getDeclaredMethod(methodName, class_327.class, List.class, Integer.TYPE, Integer.TYPE, class_8000.class);
                }
                catch (NoSuchMethodException e) {
                    if (!errorLogged) {
                        LOGGER.error("Failed to render Screenshot Viewer tooltip", (Throwable)e);
                        errorLogged = true;
                    }
                    return;
                }
                DRAW_TOOLTIP.setAccessible(true);
            }
            try {
                DRAW_TOOLTIP.invoke((Object)context, textRenderer, tooltipComponents, posX, posY, class_8001.field_41687);
            }
            catch (Exception e) {
                if (errorLogged) break block6;
                LOGGER.error("Failed to render Screenshot Viewer tooltip", (Throwable)e);
                errorLogged = true;
            }
        }
    }

    public static void forEachDrawable(class_437 screen, Consumer<class_4068> renderer) {
        ScreenshotViewerUtils.forEachOfType(screen, class_4068.class, renderer);
    }

    public static <T> void forEachOfType(class_437 screen, Class<T> type, Consumer<T> action) {
        screen.method_25396().stream().filter(type::isInstance).map(type::cast).forEachOrdered(action);
    }

    record ImageTransferable(Image image) implements Transferable
    {
        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image();
        }
    }

    static class ColoredTooltipComponent
    implements class_5684 {
        private final class_5481 text;

        public ColoredTooltipComponent(class_5481 text) {
            this.text = text;
        }

        public int method_32664(class_327 textRenderer) {
            return textRenderer.method_30880(this.text);
        }

        public int method_32661() {
            return 10;
        }

        public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
            float[] colors = RenderSystem.getShaderColor();
            if (colors.length != 4) {
                colors = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            }
            int alpha = Math.max((int)(colors[3] * 255.0f), 5);
            int textColor = class_5253.class_5254.method_27764((int)alpha, (int)((int)(colors[0] * 255.0f)), (int)((int)(colors[1] * 255.0f)), (int)((int)(colors[2] * 255.0f)));
            textRenderer.method_22942(this.text, (float)x, (float)y, textColor, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }
}

