/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.google.gson.Gson;
import com.koteinik.chunksfadein.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;

public class ModrinthApi {
    private static final String API_LINK = "https://api.modrinth.com/v2/";
    private static final String MOD_VERSIONS = "https://modrinth.com/mod/chunks-fade-in/version/";
    private static final String VERSIONS_ENDPOINT = "https://api.modrinth.com/v2/project/chunks-fade-in/version";
    private static String minecraftVersion;

    public static void load() {
        minecraftVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
    }

    public static ModrinthVersion getLatestModVersion() {
        try {
            String rawBody = ModrinthApi.executeGet(VERSIONS_ENDPOINT, "featured=true", "game_versions=[\"" + minecraftVersion + "\"]");
            List jsonList = (List)new Gson().fromJson(rawBody, List.class);
            Object jsonObject = jsonList.get(0);
            Map jsonMap = (Map)jsonObject;
            Object versionObj = jsonMap.get("version_number");
            Object changelogObj = jsonMap.get("changelog");
            String version = (String)versionObj;
            String changelog = (String)changelogObj;
            return new ModrinthVersion(Version.parse((String)version.replaceAll("v", "")), changelog, MOD_VERSIONS + version);
        }
        catch (Exception e) {
            Logger.warn("Failed to get latest mod version! Cause: " + e.getMessage());
            return null;
        }
    }

    private static String executeGet(String urlString, String ... paramsArr) {
        try {
            String inputLine;
            Object paramsStr = "";
            for (int i = 0; i < paramsArr.length; ++i) {
                paramsStr = i == 0 ? (String)paramsStr + "?" : (String)paramsStr + "&";
                paramsStr = (String)paramsStr + URLEncoder.encode(paramsArr[i], "UTF-8").replaceAll("%3D", "=");
            }
            URL url = new URL(urlString + (String)paramsStr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Content-Type", "application/json");
            con.setConnectTimeout(10000);
            con.setReadTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            Object body = "";
            while ((inputLine = in.readLine()) != null) {
                body = (String)body + inputLine;
            }
            in.close();
            con.disconnect();
            return body;
        }
        catch (Exception e) {
            Logger.warn("Failed to execute get http request on '" + urlString + "'! Cause: " + e.getMessage());
            return null;
        }
    }

    public static class ModrinthVersion {
        public final Version version;
        public final String changelog;
        public final String downloadUrl;

        public ModrinthVersion(Version version, String changelog, String downloadUrl) {
            this.version = version;
            this.changelog = changelog;
            this.downloadUrl = downloadUrl;
        }
    }
}

