/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.gui.components.ChunksFadeInButton;
import com.koteinik.chunksfadein.gui.components.ChunksFadeInSlider;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class GuiUtils {
    public static final int SPACING_Y = 28;
    public static final int SPACING_X = 4;
    private static final int BUTTON_W = 180;
    private static final int BUTTON_H = 20;

    public static class_2561 toggledText(String key, boolean value) {
        return GuiUtils.coloredFormatted(key, GuiUtils.color(value), value ? SettingsScreen.ON : SettingsScreen.OFF);
    }

    public static class_2561 choiceText(String key, boolean value) {
        return GuiUtils.coloredFormatted(key, GuiUtils.color(value), value ? SettingsScreen.YES : SettingsScreen.NO);
    }

    public static class_2561 doubleText(String key, double value) {
        return GuiUtils.formattedText(key, MathUtils.round(value, 2));
    }

    public static class_2561 coloredFormatted(String key, String color, class_2561 arg) {
        return GuiUtils.formattedText(key, color + arg.getString());
    }

    public static class_2561 text(String key) {
        return GuiUtils.formattedText(key, new Object[0]);
    }

    public static class_2561 formattedText(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }

    public static ChunksFadeInButton choiceButton(class_437 screen, int column, int row, String textKey, String configKey) {
        return GuiUtils.choiceButton(screen, column, row, textKey, configKey, null, null);
    }

    public static ChunksFadeInButton choiceButton(class_437 screen, int column, int row, String textKey, String configKey, Boolean forcedValue, class_2561 tooltip) {
        return GuiUtils.button(screen, column, row, () -> GuiUtils.choiceText(textKey, Config.getBoolean(configKey)), () -> Config.flipBoolean(configKey), forcedValue, tooltip);
    }

    public static ChunksFadeInButton toggledButton(class_437 screen, int column, int row, String textKey, String configKey) {
        return GuiUtils.toggledButton(screen, column, row, textKey, configKey, null, null);
    }

    public static ChunksFadeInButton toggledButton(class_437 screen, int column, int row, String textKey, String configKey, Boolean forcedValue, class_2561 tooltip) {
        return GuiUtils.button(screen, column, row, () -> GuiUtils.toggledText(textKey, Config.getBoolean(configKey)), () -> Config.flipBoolean(configKey), forcedValue, tooltip);
    }

    public static ChunksFadeInButton doneButton(class_437 screen) {
        return new ChunksFadeInButton(GuiUtils.calculateX(screen.field_22789, 0), screen.field_22790 - 20 - 8, 180, 20, () -> class_5244.field_24334, () -> screen.method_25419());
    }

    public static ChunksFadeInSlider slider(SettingsScreen screen, int column, int row, DoubleSupplier updateValue, DoubleSupplier displayValue, String textKey, String configKey, double scale) {
        ChunksFadeInSlider slider = new ChunksFadeInSlider(GuiUtils.calculateX(screen.field_22789, column), GuiUtils.calculateY(screen.field_22790, row), 180, 20, updateValue, value -> GuiUtils.doubleText(textKey, displayValue.getAsDouble()), value -> Config.setDouble(configKey, value), scale);
        return slider;
    }

    public static ChunksFadeInButton button(class_437 screen, int column, int row, Supplier<class_2561> createText, Runnable onPressed) {
        return GuiUtils.button(screen, column, row, createText, onPressed, null, null);
    }

    public static ChunksFadeInButton button(class_437 screen, int column, int row, Supplier<class_2561> createText, Runnable onPressed, Boolean forcedValue, class_2561 tooltip) {
        return new ChunksFadeInButton(GuiUtils.calculateX(screen.field_22789, column), GuiUtils.calculateY(screen.field_22790, row), 180, 20, createText, onPressed, forcedValue, tooltip);
    }

    private static int calculateY(int screenSize, int row) {
        return screenSize / 2 - 10 + row * 28;
    }

    private static int calculateX(int screenSize, int column) {
        int halfScreen = screenSize / 2;
        return column == 0 ? halfScreen - 90 : halfScreen + 180 * (column - (column < 0 ? 0 : 1)) + 4 * column;
    }

    private static String color(boolean value) {
        return value ? "\u00a72" : "\u00a7c";
    }
}

