/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.config.Config;
import dev.tr7zw.exordium.util.BlendSateHolder;
import dev.tr7zw.exordium.util.Model;
import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import org.joml.Vector3f;

public abstract class BufferedComponent {
    private static final class_310 minecraft = class_310.method_1551();
    private static Model model = null;
    private final Supplier<Config.ComponentSettings> settings;
    private class_276 guiTarget = new class_6367(100, 100, true, false);
    private long cooldown = System.currentTimeMillis();
    private int guiScale = 0;
    private boolean isRendering = false;
    private boolean forceBlending = false;
    private BlendSateHolder blendSateHolder = new BlendSateHolder();

    public static Model getModel() {
        return model;
    }

    public BufferedComponent(Supplier<Config.ComponentSettings> settings) {
        this(false, settings);
    }

    public BufferedComponent(boolean forceBlending, Supplier<Config.ComponentSettings> settings) {
        this.forceBlending = forceBlending;
        this.settings = settings;
    }

    private static void refreshModel(int screenWidth, int screenHeight) {
        if (model != null) {
            model.close();
        }
        Vector3f[] modelData = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, 0.0f, -90.0f), new Vector3f(0.0f, 0.0f, -90.0f)};
        Model.Vector2f[] uvData = new Model.Vector2f[]{new Model.Vector2f(0.0f, 0.0f), new Model.Vector2f(1.0f, 0.0f), new Model.Vector2f(1.0f, 1.0f), new Model.Vector2f(0.0f, 1.0f)};
        model = new Model(modelData, uvData);
    }

    public boolean render() {
        boolean updateFrame;
        if (!this.settings.get().enabled) {
            return false;
        }
        if (!this.blendSateHolder.isBlendStateFetched()) {
            return false;
        }
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        boolean forceRender = false;
        if (this.guiTarget.field_1482 != minecraft.method_22683().method_4489() || this.guiTarget.field_1481 != minecraft.method_22683().method_4506() || (Integer)BufferedComponent.minecraft.field_1690.method_42474().method_41753() != this.guiScale) {
            this.guiTarget.method_1234(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506(), true);
            BufferedComponent.refreshModel(screenWidth, screenHeight);
            this.guiScale = (Integer)BufferedComponent.minecraft.field_1690.method_42474().method_41753();
            forceRender = true;
        }
        if (model == null) {
            BufferedComponent.refreshModel(screenWidth, screenHeight);
        }
        boolean bl = updateFrame = forceRender || System.currentTimeMillis() > this.cooldown && (this.settings.get().forceUpdates || this.needsRenderPaced());
        if (!updateFrame) {
            ExordiumModBase.instance.getDelayedRenderCallManager().addBufferedComponent(this);
            this.blendSateHolder.apply();
            return true;
        }
        this.guiTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.guiTarget.method_1230(false);
        this.guiTarget.method_1235(false);
        this.isRendering = true;
        ExordiumModBase.instance.setTemporaryScreenOverwrite(this.guiTarget);
        ExordiumModBase.correctBlendMode();
        if (this.forceBlending || this.settings.get().forceBlend) {
            ExordiumModBase.setForceBlend(true);
        }
        this.guiTarget.method_1235(false);
        return false;
    }

    public void renderEnd() {
        if (!this.blendSateHolder.isBlendStateFetched()) {
            this.blendSateHolder.fetch();
        }
        if (!this.isRendering) {
            return;
        }
        this.captureState();
        ExordiumModBase.instance.setTemporaryScreenOverwrite(null);
        this.guiTarget.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
        this.cooldown = System.currentTimeMillis() + (long)(1000 / this.settings.get().maxFps);
        this.isRendering = false;
        if (this.forceBlending || this.settings.get().forceBlend) {
            ExordiumModBase.setForceBlend(false);
        }
        ExordiumModBase.instance.getDelayedRenderCallManager().addBufferedComponent(this);
        this.blendSateHolder.apply();
    }

    private void renderTextureOverlay(int textureid) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureid);
        model.draw(RenderSystem.getModelViewMatrix());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getTextureId() {
        return this.guiTarget.method_30277();
    }

    public boolean isRendering() {
        return this.isRendering;
    }

    private boolean needsRenderPaced() {
        if (this.needsRender()) {
            return true;
        }
        this.cooldown = System.currentTimeMillis() + (long)(1000 / ExordiumModBase.instance.config.pollRate);
        return false;
    }

    public abstract boolean needsRender();

    public abstract void captureState();
}

