/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import java.util.Random;

public class SegmentedManager {
    public static final long SIZE_LIMIT = -1L;
    private final int ADDR_BITS = 34;
    private final int SIZE_BITS = 30;
    private final long SIZE_MSK = 0x3FFFFFFFL;
    private final long ADDR_MSK = 0x3FFFFFFFFL;
    private final LongRBTreeSet FREE = new LongRBTreeSet();
    private final LongRBTreeSet TAKEN = new LongRBTreeSet();
    private long sizeLimit = Long.MAX_VALUE;
    private long totalSize;
    public boolean resized;

    public long getSize() {
        return this.totalSize;
    }

    public long alloc(int size) {
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        LongBidirectionalIterator iter = this.FREE.iterator(((long)size << 34) - 1L);
        if (!iter.hasNext()) {
            this.resized = true;
            long addr = this.totalSize;
            if (this.totalSize + (long)size > this.sizeLimit) {
                return -1L;
            }
            this.totalSize += (long)size;
            this.TAKEN.add(addr << 30 | (long)size);
            return addr;
        }
        long slot = iter.nextLong();
        iter.remove();
        if (slot >>> 34 == (long)size) {
            this.TAKEN.add(slot << 30 | slot >>> 34);
        } else {
            this.TAKEN.add((slot & 0x3FFFFFFFFL) << 30 | (long)size);
            this.FREE.add((slot >>> 34) - (long)size << 34 | (slot & 0x3FFFFFFFFL) + (long)size);
        }
        this.resized = false;
        return slot & 0x3FFFFFFFFL;
    }

    public int free(long addr) {
        long delta;
        long endAddr;
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        long size = slot & 0x3FFFFFFFL;
        iter.remove();
        if (iter.hasPrevious()) {
            long prevSlot = iter.previousLong();
            endAddr = (prevSlot >>> 30) + (prevSlot & 0x3FFFFFFFL);
            if (endAddr != addr) {
                delta = addr - endAddr;
                this.FREE.remove(delta << 34 | endAddr);
                slot = endAddr << 30 | (slot & 0x3FFFFFFFL) + delta;
            }
            iter.nextLong();
        } else if (!this.FREE.isEmpty() && this.FREE.remove(addr << 34)) {
            slot = addr + size;
        }
        if (iter.hasNext()) {
            endAddr = (slot >>> 30) + (slot & 0x3FFFFFFFL);
            long nextSlot = iter.nextLong();
            if (endAddr != nextSlot >>> 30) {
                delta = (nextSlot >>> 30) - endAddr;
                this.FREE.remove(delta << 34 | endAddr);
                slot = slot & 0xFFFFFFFFC0000000L | (slot & 0x3FFFFFFFL) + delta;
            }
        } else {
            this.resized = true;
            this.totalSize -= slot & 0x3FFFFFFFL;
            return (int)size;
        }
        this.resized = false;
        slot = slot >>> 30 | slot << 34;
        this.FREE.add(slot);
        return (int)size;
    }

    public boolean expand(long addr, int extra) {
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        if (!iter.hasNext()) {
            return false;
        }
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        long updatedSlot = slot & 0xFFFFFFFFC0000000L | (slot & 0x3FFFFFFFL) + (long)extra;
        this.resized = false;
        if (iter.hasNext()) {
            long endAddr;
            long next = iter.nextLong();
            long delta = (next >>> 30) - (endAddr = (slot >>> 30) + (slot & 0x3FFFFFFFL));
            if ((long)extra <= delta) {
                this.FREE.remove(delta << 34 | endAddr);
                iter.previousLong();
                iter.previousLong();
                iter.remove();
                this.TAKEN.add(updatedSlot);
                if ((long)extra != delta) {
                    this.FREE.add(delta - (long)extra << 34 | endAddr + (long)extra);
                }
                return true;
            }
            return false;
        }
        if (this.totalSize + (long)extra > this.sizeLimit) {
            return false;
        }
        iter.remove();
        this.TAKEN.add(updatedSlot);
        this.totalSize += (long)extra;
        this.resized = true;
        return true;
    }

    public long getSize(long addr) {
        LongBidirectionalIterator iter = this.TAKEN.iterator((addr &= 0x3FFFFFFFFL) << 30);
        if (!iter.hasNext()) {
            throw new IllegalArgumentException();
        }
        long slot = iter.nextLong();
        if (slot >> 30 != addr) {
            throw new IllegalStateException();
        }
        return slot & 0x3FFFFFFFL;
    }

    public static void main(String[] args) {
        for (int j = 0; j < 10000; ++j) {
            Random r = new Random(j);
            SegmentedManager m = new SegmentedManager();
            LongArrayList l = new LongArrayList();
            for (int i = 0; i < 5000; ++i) {
                int ac = r.nextInt(3);
                if (ac == 0 || l.isEmpty()) {
                    long a = m.alloc(r.nextInt(1000) + 1);
                    l.add(a);
                    continue;
                }
                if (ac == 1) {
                    m.free(l.removeLong(r.nextInt(l.size())));
                    continue;
                }
                m.expand(l.getLong(r.nextInt(l.size())), r.nextInt(10) + 1);
            }
            LongListIterator longListIterator = l.iterator();
            while (longListIterator.hasNext()) {
                long a = (Long)longListIterator.next();
                m.free(a);
            }
            if (m.getSize() == 0L) continue;
            System.out.println(j);
            return;
        }
    }

    public void setLimit(long size) {
        this.sizeLimit = size;
    }
}

