/*
 * Decompiled with CFR 0.152.
 */
package xyz.trivaxy.tia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import xyz.trivaxy.tia.TiaMod;

public class TiaConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("tia.json");
    private static final File CONFIG_FILE = CONFIG_PATH.toFile();
    private static final float defaultAnimationSpeed = 0.5f;
    private static final float defaultPickupScale = 1.4f;
    public static float animationSpeed = 0.5f;
    public static float pickupScale = 1.4f;

    public static void load() {
        if (!CONFIG_FILE.isFile()) {
            TiaMod.LOGGER.info("Config file not found, creating one...");
            try {
                TiaConfig.createDefaultConfigFile();
            }
            catch (IOException e) {
                TiaConfig.logError("Could not create config file", e);
                return;
            }
        }
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_PATH), JsonObject.class);
            animationSpeed = config.get("animation_speed").getAsFloat();
            pickupScale = config.get("pickup_scale").getAsFloat();
        }
        catch (IOException e) {
            TiaConfig.logError("Could not read config file", e);
        }
        catch (NullPointerException e) {
            TiaConfig.logError("Config file is invalid", e);
        }
    }

    private static void createDefaultConfigFile() throws IOException {
        JsonObject config = new JsonObject();
        config.addProperty("animation_speed", (Number)Float.valueOf(0.5f));
        config.addProperty("pickup_scale", (Number)Float.valueOf(1.4f));
        BufferedWriter writer = new BufferedWriter(new FileWriter(CONFIG_FILE, false));
        writer.write(GSON.toJson((JsonElement)config));
        writer.close();
    }

    private static void logError(String message, Exception exception) {
        TiaMod.LOGGER.error(message + ": " + exception.getMessage());
        TiaMod.LOGGER.error("Using default values instead");
    }
}

