/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.modConfig;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.config.ConfigManager;
import com.HiWord9.RPRenames.util.gui.RenameButtonHolder;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.math.Color;
import org.apache.commons.compress.utils.IOUtils;

@Config(name="rprenames")
public class ModConfig
implements ConfigData {
    public boolean ignoreCEM = false;
    public boolean enableAnvilModification = true;
    public int favoritePosX = 71;
    public int favoritePosY = -75;
    public boolean compareItemGroupRenames = true;
    public boolean generateSpawnEggsInItemGroup = true;
    public boolean loadModBuiltinResources = true;
    public boolean openByDefault = false;
    public RenameButtonHolder.ViewMode viewMode = RenameButtonHolder.ViewMode.GRID;
    public boolean offsetMenu = true;
    public boolean showPackName = true;
    public boolean showExtraProperties = true;
    public boolean renderMobRenamesAsEntities = true;
    public boolean highlightSlot = true;
    public int slotHighlightColorALPHA = 50;
    public int slotHighlightColorRGB = 0x80FFFF;
    public boolean highlightTooltipSlotWrong = true;
    public boolean highlightTooltipSlotSelected = false;
    public boolean enablePreview = true;
    public RenameButtonHolder.PreviewPos previewPos = RenameButtonHolder.PreviewPos.LEFT;
    public boolean playerPreviewByDefault = false;
    public boolean spinMobPreview = true;
    public boolean spinPlayerPreview = false;
    public boolean disableSnowGolemPumpkin = false;
    public double scaleFactorItem = 2.0;
    public double scaleFactorEntity = 1.0;
    public boolean alwaysAllowPlayerPreviewHead = false;
    public boolean disablePageArrowsTips = false;
    public boolean disablePlayerPreviewTips = false;
    public boolean updateConfig = true;
    public boolean showNbtDisplayName = false;
    public boolean showOriginalProperties = false;
    public boolean showDescription = true;
    public static final ModConfig INSTANCE = ModConfig.read();
    private Boolean shouldUpdateItemGroup = null;

    public void setCompareItemGroupRenames(boolean compareItemGroupRenames) {
        if (this.shouldUpdateItemGroup == null || !this.shouldUpdateItemGroup.booleanValue()) {
            this.shouldUpdateItemGroup = compareItemGroupRenames != this.compareItemGroupRenames;
        }
        this.compareItemGroupRenames = compareItemGroupRenames;
    }

    public void setGenerateSpawnEggsInItemGroup(boolean generateSpawnEggsInItemGroup) {
        if (this.shouldUpdateItemGroup == null || !this.shouldUpdateItemGroup.booleanValue()) {
            this.shouldUpdateItemGroup = generateSpawnEggsInItemGroup != this.generateSpawnEggsInItemGroup;
        }
        this.generateSpawnEggsInItemGroup = generateSpawnEggsInItemGroup;
    }

    public int getSlotHighlightRGBA() {
        int r = Color.ofTransparent((int)this.slotHighlightColorRGB).getRed();
        int g = Color.ofTransparent((int)this.slotHighlightColorRGB).getGreen();
        int b = Color.ofTransparent((int)this.slotHighlightColorRGB).getBlue();
        return Color.ofRGBA((int)r, (int)g, (int)b, (int)((int)((float)this.slotHighlightColorALPHA / 100.0f * 255.0f))).getColor();
    }

    public static ModConfig read() {
        ModConfig modConfig;
        if (!RPRenames.MOD_CONFIG_FILE.exists()) {
            return new ModConfig().write();
        }
        FileReader reader = null;
        try {
            reader = new FileReader(RPRenames.MOD_CONFIG_FILE);
            modConfig = (ModConfig)new Gson().fromJson((Reader)reader, ModConfig.class);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        return modConfig;
    }

    public ModConfig write() {
        if (this.shouldUpdateItemGroup != null && this.shouldUpdateItemGroup.booleanValue()) {
            ConfigManager.updateItemGroup();
        }
        this.shouldUpdateItemGroup = null;
        Gson gson = new Gson();
        JsonWriter writer = null;
        try {
            writer = gson.newJsonWriter((Writer)new FileWriter(RPRenames.MOD_CONFIG_FILE));
            writer.setIndent("    ");
            gson.toJson(gson.toJsonTree((Object)this, ModConfig.class), writer);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
        return this;
    }
}

