/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigapiport.api.config.v3.ModConfigEvents;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Callable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3542;
import net.neoforged.fml.config.ConfigFileTypeHandler;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;

public class ModConfig {
    private final Type type;
    private final IConfigSpec<?> spec;
    private final String fileName;
    private final String modId;
    private final ConfigFileTypeHandler configHandler;
    private CommentedConfig configData;
    private Callable<Void> saveHandler;

    public ModConfig(Type type, IConfigSpec<?> spec, String modId, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            throw new IllegalArgumentException("No mod with id '%s'".formatted(modId));
        }
        this.modId = modId;
        this.configHandler = ConfigFileTypeHandler.TOML;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    public ModConfig(Type type, IConfigSpec<?> spec, String modId) {
        this(type, spec, modId, ModConfig.defaultConfigName(type, modId));
    }

    private static String defaultConfigName(Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConfigFileTypeHandler getHandler() {
        return this.configHandler;
    }

    public <T extends IConfigSpec<T>> IConfigSpec<T> getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.modId;
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.acceptConfig(this.configData);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public void acceptSyncedConfig(byte[] bytes) {
        if (bytes != null) {
            this.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes)));
            ((NeoForgeModConfigEvents.Reloading)NeoForgeModConfigEvents.reloading(this.getModId()).invoker()).onModConfigReloading(this);
            ((ModConfigEvents.Reloading)ModConfigEvents.reloading(this.getModId()).invoker()).onModConfigReloading(this);
        } else {
            this.setConfigData(null);
            ((NeoForgeModConfigEvents.Unloading)NeoForgeModConfigEvents.unloading(this.getModId()).invoker()).onModConfigUnloading(this);
            ((ModConfigEvents.Unloading)ModConfigEvents.unloading(this.getModId()).invoker()).onModConfigUnloading(this);
        }
    }

    public static enum Type implements class_3542
    {
        COMMON,
        CLIENT,
        SERVER;


        public String extension() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String method_15434() {
            return this.extension();
        }
    }
}

