/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import nl.teamdiopside.seamless.Reload;
import nl.teamdiopside.seamless.Seamless;

public class OutlineFinder {
    public static Recursion findAndAddShapes(class_1937 level, class_2680 state, class_2338 pos, Set<class_2338> connectedPositions, class_2338 originalPos, class_1297 entity) {
        connectedPositions.add(pos);
        class_2338 relativePos = pos.method_10059((class_2382)originalPos);
        class_265 shape = state.method_26172((class_1922)level, pos, class_3726.method_16195((class_1297)entity)).method_1096((double)relativePos.method_10263(), (double)relativePos.method_10264(), (double)relativePos.method_10260());
        if (connectedPositions.size() > 1500) {
            return new Recursion(shape, connectedPositions);
        }
        for (Reload.OutlineRule outlineRule : Reload.RULES) {
            class_2960 location = outlineRule.location();
            if (OutlineFinder.blockDoesntMatch(outlineRule.blocks(), state.method_26204(), null, location)) continue;
            boolean blockstatesMatch = true;
            for (Map.Entry<String, Set<String>> entry : outlineRule.blockstates().entrySet()) {
                if (!OutlineFinder.propertyDoesntMatch(state, entry.getKey(), entry.getValue(), null, location)) continue;
                blockstatesMatch = false;
            }
            if (!blockstatesMatch) continue;
            for (class_2350 direction : OutlineFinder.getDirections(outlineRule.directions(), location, state)) {
                class_2338 checkingPos = pos.method_10093(direction);
                class_2680 checkingState = level.method_8320(checkingPos);
                if (connectedPositions.contains(checkingPos) || OutlineFinder.blockDoesntMatch(outlineRule.connectingBlocks(), checkingState.method_26204(), state.method_26204(), location)) continue;
                boolean connectingBlockstatesMatch = true;
                for (Map.Entry<String, Set<String>> entry : outlineRule.connectingBlockstates().entrySet()) {
                    if (!OutlineFinder.propertyDoesntMatch(checkingState, entry.getKey(), entry.getValue(), state, location)) continue;
                    connectingBlockstatesMatch = false;
                    break;
                }
                if (!connectingBlockstatesMatch) continue;
                Recursion recursion = OutlineFinder.findAndAddShapes(level, checkingState, checkingPos, connectedPositions, originalPos, entity);
                shape = class_259.method_1082((class_265)shape, (class_265)recursion.voxelShape(), (class_247)class_247.field_1366);
                connectedPositions = recursion.connectedPositions();
            }
        }
        return new Recursion(shape, connectedPositions);
    }

    public static boolean blockDoesntMatch(Set<String> set, class_2248 checkingBlock, class_2248 originalBlock, class_2960 location) {
        HashSet<class_2248> goodBlocks = new HashSet<class_2248>();
        HashSet<class_2248> nonoBlocks = new HashSet<class_2248>();
        for (String string : set) {
            if (originalBlock != null) {
                if (string.equals("/same")) {
                    goodBlocks.add(originalBlock);
                } else if (string.equals("/!same")) {
                    nonoBlocks.add(originalBlock);
                }
            }
            if (string.startsWith("!")) {
                nonoBlocks.addAll(OutlineFinder.getBlocks(string.substring(1), location));
                continue;
            }
            goodBlocks.addAll(OutlineFinder.getBlocks(string, location));
        }
        return !goodBlocks.contains(checkingBlock) || nonoBlocks.contains(checkingBlock);
    }

    public static Set<class_2248> getBlocks(String string, class_2960 location) {
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        if (string.startsWith("#")) {
            class_6862 blockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(string.replace("#", "")));
            class_7923.field_41175.method_40260(blockTagKey).method_40239().forEach(blockHolder -> blocks.add((class_2248)blockHolder.comp_349()));
        } else {
            if (!Seamless.modIds.contains(string.replace("#", "").split(":")[0])) {
                return blocks;
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(string));
            if (block == class_2246.field_10124 && !string.split(":")[1].equals("air")) {
                OutlineFinder.initialError("Block \"" + string + "\" from " + location + " does not exist!");
            } else {
                blocks.add(block);
            }
        }
        return blocks;
    }

    public static boolean propertyDoesntMatch(class_2680 checkingState, String propertyName, Set<String> values, class_2680 originalState, class_2960 location) {
        class_2769 checkingProperty = checkingState.method_26204().method_9595().method_11663(propertyName);
        if (checkingProperty == null) {
            OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + location + " does not exist for " + checkingState.method_26204().method_9518());
            return true;
        }
        String valueName = checkingState.method_11654(checkingProperty).toString();
        Comparable comparable = checkingState.method_11654(checkingProperty);
        if (comparable instanceof class_3542) {
            class_3542 representable = (class_3542)comparable;
            valueName = representable.method_15434();
        }
        HashSet<String> goodValues = new HashSet<String>(Set.copyOf(values));
        HashSet nonoValues = new HashSet();
        boolean useNono = false;
        if (originalState != null) {
            for (String value : values) {
                class_2769 originalProperty;
                if (!value.startsWith("/same") && !value.startsWith("/!same")) continue;
                String addToPropertyString = value.contains("+") ? value.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Blockstate \"" + value + "\" from " + location + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((originalProperty = originalState.method_26204().method_9595().method_11663(propertyName)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + location + " does not exist for " + originalState.method_26204().method_9518());
                    continue;
                }
                HashSet<String> toAdd = new HashSet<String>();
                if (originalProperty instanceof class_2753) {
                    class_2753 directionProperty = (class_2753)originalProperty;
                    class_2350 direction = (class_2350)originalState.method_11654((class_2769)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.method_10170();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.method_10153();
                    }
                    toAdd.add(direction.method_10151());
                } else if (originalProperty == class_2741.field_12496) {
                    toAdd.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)originalState.method_11654((class_2769)class_2741.field_12496)), (class_2350.class_2352)class_2350.class_2352.field_11060).toString());
                    toAdd.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)originalState.method_11654((class_2769)class_2741.field_12496)), (class_2350.class_2352)class_2350.class_2352.field_11056).toString());
                } else if (originalProperty == class_2741.field_12529) {
                    toAdd.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)originalState.method_11654((class_2769)class_2741.field_12529)), (class_2350.class_2352)class_2350.class_2352.field_11060).toString());
                    toAdd.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)originalState.method_11654((class_2769)class_2741.field_12529)), (class_2350.class_2352)class_2350.class_2352.field_11056).toString());
                } else if (originalProperty instanceof class_2758) {
                    class_2758 integerProperty = (class_2758)originalProperty;
                    toAdd.add(String.valueOf((Integer)originalState.method_11654((class_2769)integerProperty) + addToProperty));
                } else {
                    toAdd.add(String.valueOf(originalState.method_11654(originalProperty)));
                }
                if (value.startsWith("/same")) {
                    goodValues.addAll(toAdd);
                    continue;
                }
                if (!value.startsWith("/!same")) continue;
                useNono = true;
                nonoValues.addAll(toAdd);
            }
        }
        boolean propertiesMatch = propertyName.equals(checkingProperty.method_11899());
        boolean valuesMatch = goodValues.contains(valueName) || !nonoValues.contains(valueName) && useNono;
        return !propertiesMatch || !valuesMatch;
    }

    public static Set<class_2350> getDirections(Set<String> set, class_2960 location, class_2680 state) {
        HashSet<class_2350> directions = new HashSet<class_2350>();
        for (String string : set) {
            if (string.startsWith("/state:")) {
                class_2769 property;
                String propertyString = string.split(":")[1].split("\\+")[0];
                String addToPropertyString = string.contains("+") ? string.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        OutlineFinder.initialError("Direction \"" + string + "\" from " + location + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((property = state.method_26204().method_9595().method_11663(propertyString)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyString + "\" from " + location + " does not exist for " + state.method_26204().method_9518());
                    continue;
                }
                if (property instanceof class_2753) {
                    class_2753 directionProperty = (class_2753)property;
                    class_2350 direction = (class_2350)state.method_11654((class_2769)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.method_10170();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.method_10153();
                    }
                    directions.add(direction);
                    continue;
                }
                if (property == class_2741.field_12496) {
                    directions.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496)), (class_2350.class_2352)class_2350.class_2352.field_11060));
                    directions.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496)), (class_2350.class_2352)class_2350.class_2352.field_11056));
                    continue;
                }
                if (property == class_2741.field_12529) {
                    directions.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529)), (class_2350.class_2352)class_2350.class_2352.field_11060));
                    directions.add(class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529)), (class_2350.class_2352)class_2350.class_2352.field_11056));
                    continue;
                }
                OutlineFinder.initialError("Property \"" + propertyString + "\" from " + location + "\" is not a direction property");
                continue;
            }
            class_2350 direction = class_2350.method_10168((String)string);
            if (direction != null) {
                directions.add(direction);
                continue;
            }
            OutlineFinder.initialError("Direction \"" + string + "\" from " + location + " does not exist!");
        }
        return directions;
    }

    public static void initialError(String string) {
        if (!Seamless.errors.contains(string)) {
            Seamless.LOGGER.error(string);
            Seamless.errors.add(string);
        }
    }

    public record Recursion(class_265 voxelShape, Set<class_2338> connectedPositions) {
    }
}

