/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import nl.teamdiopside.seamless.Seamless;

public class Reload {
    public static final List<OutlineRule> RULES = new ArrayList<OutlineRule>();

    public static void reload(class_3300 resourceManager) {
        Reload.apply(Reload.getJsons(resourceManager));
    }

    public static void apply(Map<class_2960, JsonElement> jsons) {
        Seamless.fastEnabled = (Boolean)Seamless.fastOption.method_41753();
        RULES.clear();
        ArrayList<OutlineRule> temp = new ArrayList<OutlineRule>();
        ArrayList<JsonFile> files = new ArrayList<JsonFile>();
        jsons.forEach((key, json) -> files.add(new JsonFile((class_2960)key, (JsonElement)json)));
        files.sort(Comparator.comparing(jsonFile -> jsonFile.key.toString()));
        for (JsonFile file : files) {
            class_2960 key2 = file.key();
            JsonElement json2 = file.json();
            if (!Seamless.modIds.contains(key2.method_12836())) continue;
            try {
                Set<String> blocks = Reload.getSet(json2, "blocks");
                HashMap<String, Set<String>> blockstates = Reload.getBlockStates(json2, "blockstates");
                Set<String> directions = Reload.getSet(json2, "directions");
                Set<String> connectingBlocks = Reload.getSet(json2, "connecting_blocks");
                HashMap<String, Set<String>> connectingBlockstates = Reload.getBlockStates(json2, "connecting_blockstates");
                temp.add(new OutlineRule(blocks, blockstates, directions, connectingBlocks, connectingBlockstates, key2));
                Seamless.LOGGER.info("Loaded Seamless outline rule " + key2);
            }
            catch (Exception e) {
                Seamless.LOGGER.error("Failed to parse JSON for Seamless outline rule " + key2 + ".json, Error: " + e);
            }
        }
        RULES.addAll(temp);
    }

    public static Set<String> getSet(JsonElement json, String string) {
        HashSet<String> set = new HashSet<String>();
        json.getAsJsonObject().get(string).getAsJsonArray().forEach(element -> set.add(element.getAsString()));
        return set;
    }

    public static HashMap<String, Set<String>> getBlockStates(JsonElement json, String string) {
        HashMap<String, Set<String>> blockstates = new HashMap<String, Set<String>>();
        try {
            json.getAsJsonObject().get(string).getAsJsonObject().asMap().forEach((k, v) -> {
                HashSet states = new HashSet();
                v.getAsJsonArray().forEach(jsonElement -> states.add(jsonElement.getAsString()));
                blockstates.put((String)k, states);
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return blockstates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<class_2960, JsonElement> getJsons(class_3300 resourceManager) {
        String directory = "seamless_rules";
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        int i = directory.length() + 1;
        for (Map.Entry entry : resourceManager.method_14488(directory, resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet()) {
            class_2960 resourceLocation2 = (class_2960)entry.getKey();
            String string = resourceLocation2.method_12832();
            class_2960 resourceLocation22 = new class_2960(resourceLocation2.method_12836(), string.substring(i, string.length() - ".json".length()));
            try (BufferedReader reader = ((class_3298)entry.getValue()).method_43039();){
                JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)reader, JsonElement.class);
                if (jsonElement != null) {
                    JsonElement jsonElement2 = map.put(resourceLocation22, jsonElement);
                    if (jsonElement2 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation22);
                }
                Seamless.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceLocation22, (Object)resourceLocation2);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Seamless.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation22, resourceLocation2, exception});
            }
        }
        return map;
    }

    public record JsonFile(class_2960 key, JsonElement json) {
    }

    public record OutlineRule(Set<String> blocks, HashMap<String, Set<String>> blockstates, Set<String> directions, Set<String> connectingBlocks, HashMap<String, Set<String>> connectingBlockstates, class_2960 location) {
    }
}

