/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.emissiveplugin.render;

import io.github.moremcmeta.emissiveplugin.fabricapi.SpriteFinder;
import io.github.moremcmeta.emissiveplugin.metadata.OverlayMetadata;
import io.github.moremcmeta.emissiveplugin.model.OverlayQuadFunction;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_6328;

@class_6328
public final class OverlayVertexConsumer
implements class_4588 {
    private static final int VERTS_PER_QUAD = 4;
    private final SpriteFinder SPRITE_FINDER;
    private final class_4588 DELEGATE;
    private final List<Task>[] TASKS;
    private final boolean[] HAS_UV;
    private final float[] TEX_U;
    private final float[] TEX_V;
    private final int[] LIGHT_U;
    private final int[] LIGHT_V;
    private final int[] RED;
    private final int[] GREEN;
    private final int[] BLUE;
    private int currentVertex;

    public OverlayVertexConsumer(SpriteFinder spriteFinder, class_4588 delegate) {
        this.SPRITE_FINDER = Objects.requireNonNull(spriteFinder, "Sprite finder cannot be null");
        this.DELEGATE = Objects.requireNonNull(delegate, "Delegate cannot be null");
        this.TASKS = (List[])Stream.generate(ArrayList::new).limit(4L).toArray(List[]::new);
        this.HAS_UV = new boolean[4];
        this.TEX_U = new float[4];
        this.TEX_V = new float[4];
        this.LIGHT_U = new int[4];
        this.LIGHT_V = new int[4];
        this.RED = new int[4];
        this.GREEN = new int[4];
        this.BLUE = new int[4];
    }

    public class_4588 method_22912(double x, double y, double z) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, red, green, blue) -> delegate.method_22912(x, y, z));
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, r, g, b) -> delegate.method_1336(r, g, b, alpha));
        this.RED[this.currentVertex] = red;
        this.GREEN[this.currentVertex] = green;
        this.BLUE[this.currentVertex] = blue;
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, red, green, blue) -> delegate.method_22913(texU, texV));
        this.HAS_UV[this.currentVertex] = true;
        this.TEX_U[this.currentVertex] = u;
        this.TEX_V[this.currentVertex] = v;
        return this;
    }

    public class_4588 method_22917(int u, int v) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, red, green, blue) -> delegate.method_22917(u, v));
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, red, green, blue) -> delegate.method_22921(lightU, lightV));
        this.LIGHT_U[this.currentVertex] = u;
        this.LIGHT_V[this.currentVertex] = v;
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, red, green, blue) -> delegate.method_22914(x, y, z));
        return this;
    }

    public void method_1344() {
        int vertex;
        if (this.currentVertex < 3) {
            ++this.currentVertex;
            return;
        }
        boolean hasUV = true;
        float centroidU = 0.0f;
        float centroidV = 0.0f;
        for (vertex = 0; vertex < 4; ++vertex) {
            hasUV = hasUV && this.HAS_UV[vertex];
            centroidU += this.TEX_U[vertex];
            centroidV += this.TEX_V[vertex];
            this.HAS_UV[vertex] = false;
        }
        centroidU /= 4.0f;
        centroidV /= 4.0f;
        if (hasUV) {
            this.SPRITE_FINDER.find(centroidU, centroidV).ifPresent(sprite -> {
                class_2960 spriteName = sprite.method_45851().method_45816();
                MetadataRegistry.INSTANCE.metadataFromSpriteName("moremcmeta_emissive_plugin", spriteName).ifPresent(metadata -> {
                    OverlayMetadata overlayMetadata = (OverlayMetadata)metadata;
                    class_2960 overlaySpriteName = overlayMetadata.overlaySpriteName();
                    class_1058 overlaySprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(overlaySpriteName);
                    for (int vertex = 0; vertex < 4; ++vertex) {
                        int blue;
                        int green;
                        int red;
                        int lightV;
                        int lightU;
                        float newU = OverlayQuadFunction.recomputeSpriteCoordinate(this.TEX_U[vertex], sprite, overlaySprite, class_1058::method_4594, class_1058::method_4577);
                        float newV = OverlayQuadFunction.recomputeSpriteCoordinate(this.TEX_V[vertex], sprite, overlaySprite, class_1058::method_4593, class_1058::method_4575);
                        if (overlayMetadata.isEmissive()) {
                            lightU = 0xF000F0;
                            lightV = 0xF000F0;
                            red = 255;
                            green = 255;
                            blue = 255;
                        } else {
                            lightU = this.LIGHT_U[vertex];
                            lightV = this.LIGHT_V[vertex];
                            red = this.RED[vertex];
                            green = this.GREEN[vertex];
                            blue = this.BLUE[vertex];
                        }
                        this.TASKS[vertex].forEach(task -> task.run(this.DELEGATE, newU, newV, lightU, lightV, red, green, blue));
                        this.DELEGATE.method_1344();
                    }
                });
            });
        }
        this.currentVertex = 0;
        for (vertex = 0; vertex < 4; ++vertex) {
            this.TASKS[vertex].clear();
        }
    }

    public void method_22901(int red, int green, int blue, int alpha) {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, r, g, b) -> delegate.method_22901(red, green, blue, alpha));
    }

    public void method_35666() {
        this.TASKS[this.currentVertex].add((delegate, texU, texV, lightU, lightV, r, g, b) -> delegate.method_35666());
    }

    private static interface Task {
        public void run(class_4588 var1, float var2, float var3, int var4, int var5, int var6, int var7, int var8);
    }
}

