/*
 * Decompiled with CFR 0.152.
 */
package com.tamaized.voidfog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.tamaized.voidfog.VoidFog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Settings {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean enabled = true;
    public boolean scaleWithDifficulty = true;
    public boolean disableInCreative = true;
    public boolean respectTorches = true;
    public boolean prettyFog = false;
    public int voidParticleDensity = 1000;
    public int maxFogHeight = 32;
    public float fadeStartOffset = 15.0f;
    public boolean imABigBoi = false;
    private transient Path path;

    public float setParticleDensity(float density) {
        float f = density > 9997.0f ? 10000.0f : (density = density < 3.0f ? 0.0f : density);
        if (Math.abs(density - 1000.0f) < 30.0f) {
            density = 1000.0f;
        }
        this.voidParticleDensity = (int)density;
        return this.voidParticleDensity;
    }

    public float setFogHeight(float height) {
        this.maxFogHeight = (int)height;
        return this.maxFogHeight;
    }

    public float setFadeStart(float value) {
        this.fadeStartOffset = value;
        return this.maxFogHeight;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Settings load(Path path) {
        if (!Files.isReadable(path)) return new Settings().save(path);
        try (BufferedReader s = Files.newBufferedReader(path);){
            Settings result = (Settings)gson.fromJson((Reader)s, Settings.class);
            if (result == null) return new Settings().save(path);
            Settings settings = result.save(path);
            return settings;
        }
        catch (JsonParseException | IOException e) {
            VoidFog.LOGGER.warn("Erorr whilst loading json config", e);
        }
        return new Settings().save(path);
    }

    protected void validate() {
        this.voidParticleDensity = Math.max(0, this.voidParticleDensity);
        this.fadeStartOffset = Math.max(0.0f, this.fadeStartOffset);
    }

    private Settings save(Path path) {
        this.path = path;
        this.validate();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            VoidFog.LOGGER.warn("Error whilst saving Json config", (Throwable)e);
        }
        return this;
    }

    public void save() {
        this.save(this.path);
    }
}

