/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import mod.crend.dynamiccrosshair.config.CrosshairMode;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class ConfigUpdater
implements mod.crend.yaclx.opt.ConfigUpdater {
    private Stream<class_1792> buildAdditionalItemList(String configString) {
        return Arrays.stream(configString.split(";")).filter(s -> !s.isBlank()).map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0));
    }

    private boolean updateAdditionalItems(JsonObject json, String name) {
        if (!json.has(name)) {
            return false;
        }
        JsonElement additionalItems = json.get(name);
        if (additionalItems.isJsonPrimitive()) {
            JsonArray items = new JsonArray();
            this.buildAdditionalItemList(additionalItems.getAsString()).forEach(item -> items.add(class_7923.field_41178.method_10221(item).toString()));
            json.remove(name);
            json.add(name, (JsonElement)items);
            return true;
        }
        return false;
    }

    private boolean updateDynamicCrosshairMode(JsonObject json) {
        JsonPrimitive dynamicCrosshairP;
        JsonElement dynamicCrosshair;
        if (json.has("dynamicCrosshair") && (!((dynamicCrosshair = json.get("dynamicCrosshair")) instanceof JsonPrimitive) || (dynamicCrosshairP = (JsonPrimitive)dynamicCrosshair).isBoolean())) {
            json.add("dynamicCrosshair", (JsonElement)new JsonPrimitive(CrosshairMode.Advanced.toString()));
            return true;
        }
        return false;
    }

    private boolean updateBlockTargeting(JsonObject json) {
        JsonPrimitive onBlock;
        JsonObject crosshairConfig;
        Object object;
        JsonElement jsonElement = json.get("crosshairConfig");
        if (jsonElement instanceof JsonObject && (object = (crosshairConfig = (JsonObject)jsonElement).get("onBlock")) instanceof JsonPrimitive && !(onBlock = (JsonPrimitive)object).isBoolean()) {
            switch (onBlock.getAsString()) {
                case "IfTargeting": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    break;
                }
                case "IfInteractable": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    break;
                }
                case "Disabled": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    break;
                }
                default: {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateDisabledModifierStyle(JsonObject json) {
        boolean result = false;
        JsonElement jsonElement = json.get("crosshairModifiers");
        if (jsonElement instanceof JsonObject) {
            JsonObject modIncorrectTool;
            JsonObject modCorrectTool;
            JsonElement crosshairConfig;
            JsonElement jsonElement2;
            JsonElement style;
            JsonObject modInteractable;
            JsonElement jsonElement3;
            JsonObject crosshairModifiers = (JsonObject)jsonElement;
            JsonElement jsonElement4 = crosshairModifiers.get("modInteractable");
            if (jsonElement4 instanceof JsonObject && (jsonElement3 = (modInteractable = (JsonObject)jsonElement4).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)jsonElement3).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
            if ((style = crosshairModifiers.get("modCorrectTool")) instanceof JsonObject && (crosshairConfig = (modCorrectTool = (JsonObject)style).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)crosshairConfig).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("displayCorrectTool", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
            if ((style = crosshairModifiers.get("modIncorrectTool")) instanceof JsonObject && (crosshairConfig = (modIncorrectTool = (JsonObject)style).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)crosshairConfig).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("displayCorrectTool", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
        }
        return result;
    }

    public boolean updateConfigFile(JsonObject json) {
        boolean result = this.updateDynamicCrosshairMode(json);
        if (this.updateBlockTargeting(json)) {
            result = true;
        }
        if (this.updateDisabledModifierStyle(json)) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalTools")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalMeleeWeapons")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalRangedWeapons")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalThrowables")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalUsableItems")) {
            result = true;
        }
        return result;
    }
}

