/*
 * Decompiled with CFR 0.152.
 */
package dev.plasticstraw.inf_music;

import dev.plasticstraw.inf_music.config.InfiniteMusicConfig;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1143;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteMusic
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"inf-music");
    public static final InfiniteMusicConfig CONFIG = InfiniteMusicConfig.load();
    public static final Tracker TRACKER = new Tracker();
    private static final List<class_5195> gameplayMusic = new ArrayList<class_5195>();
    public static final List<class_1113> musicDiscInstanceList = new ArrayList<class_1113>();
    public static final class_310 client = class_310.method_1551();
    public static class_1113 musicInstance;

    public void onInitializeClient() {
        InfiniteMusic.updateMusicDelay(class_1143.field_5585, InfiniteMusic.CONFIG.mainMenuMusic);
    }

    public static void addGameplayMusic(class_5195 musicSound) {
        gameplayMusic.add(musicSound);
    }

    public static void updateMusicDelays() {
        InfiniteMusic.updateMusicDelay(class_1143.field_5585, InfiniteMusic.CONFIG.mainMenuMusic);
        InfiniteMusic.updateMusicDelay(class_1143.field_5581, InfiniteMusic.CONFIG.creativeMusic);
        InfiniteMusic.updateMusicDelay(class_1143.field_5576, InfiniteMusic.CONFIG.underwaterMusic);
        InfiniteMusic.updateMusicDelay(class_1143.field_5583, InfiniteMusic.CONFIG.endMusic);
        for (class_5195 musicSound : gameplayMusic) {
            if (musicSound == class_1143.field_5585 || musicSound == class_1143.field_5581 || musicSound == class_1143.field_5576 || musicSound == class_1143.field_5583 || musicSound == class_1143.field_5580 || musicSound == class_1143.field_5578) continue;
            InfiniteMusic.updateMusicDelay(musicSound, InfiniteMusic.CONFIG.gameplayMusic);
        }
        TRACKER.shouldDoFullTick();
    }

    public static boolean isMusicDiscMusicPlaying() {
        for (class_1113 soundInstance : new ArrayList<class_1113>(musicDiscInstanceList)) {
            if (class_310.method_1551().method_1483().method_4877(soundInstance)) {
                return true;
            }
            musicDiscInstanceList.remove(soundInstance);
        }
        return musicDiscInstanceList.size() != 0;
    }

    private static void updateMusicDelay(class_5195 musicSound, InfiniteMusicConfig.MusicOptions config) {
        musicSound.updateMusicDelays(config.getMinTicks(), config.getMaxTicks(), config.enabled);
    }

    public static class Tracker {
        @Nullable
        private class_1113 currentMusicPlaying;
        private final class_5819 random = class_5819.method_43047();
        private float randomFloat = this.random.method_43057();
        private int timeSinceLastSong = -1;
        private boolean hasJoinedWorld = true;
        private boolean readyToPlay = false;
        private class_5195 musicSound;
        @Nullable
        private TickCondition evaluatedTickCondition;

        public void tick() {
            this.musicSound = client.method_1544();
            if (this.evaluatedTickCondition == null || this.evaluatedTickCondition.musicSoundType != this.musicSound) {
                this.evaluatedTickCondition = this.fullTick();
            }
            if (this.evaluatedTickCondition.tick()) {
                this.evaluatedTickCondition = null;
            }
        }

        public TickCondition fullTick() {
            final class_5195 musicSound = client.method_1544();
            if (!musicSound.enabled()) {
                this.stop(musicSound);
                return new TickCondition(musicSound);
            }
            if ((!musicSound.method_27282() || this.isPlayingType(musicSound)) && this.currentMusicPlaying != null) {
                return new TickCondition(musicSound){

                    @Override
                    public boolean tick() {
                        if (client.method_1483().method_4877(currentMusicPlaying)) {
                            return false;
                        }
                        currentMusicPlaying = null;
                        return true;
                    }
                };
            }
            if (this.hasJoinedWorld && !musicSound.equals(class_1143.field_5585)) {
                this.hasJoinedWorld = false;
                if (InfiniteMusic.CONFIG.playMusicImmediately) {
                    this.readyToPlay = true;
                }
            }
            if (musicSound.method_27280() == 0 && musicSound.method_27281() == 0) {
                this.readyToPlay = true;
            }
            if (this.readyToPlay) {
                return new TickCondition(musicSound){

                    @Override
                    public boolean tick() {
                        if (this.isDiscMusicBlocking()) {
                            return false;
                        }
                        this.stop();
                        this.play(musicSound);
                        return true;
                    }
                };
            }
            return new TickCondition(musicSound){
                private final int musicDelay;
                {
                    super(musicSoundType);
                    this.musicDelay = Math.round(randomFloat * (float)(musicSound.method_27281() - musicSound.method_27280())) + musicSound.method_27280();
                }

                @Override
                public boolean tick() {
                    ++timeSinceLastSong;
                    if (timeSinceLastSong < this.musicDelay) {
                        return false;
                    }
                    if (this.isDiscMusicBlocking()) {
                        readyToPlay = true;
                    } else {
                        this.stop();
                        this.play(musicSound);
                    }
                    return true;
                }
            };
        }

        public void play(class_5195 type) {
            if (this.isDiscMusicBlocking()) {
                return;
            }
            if (type.method_27279() == class_1144.field_5592) {
                this.timeSinceLastSong = Integer.MIN_VALUE;
                return;
            }
            this.readyToPlay = false;
            this.timeSinceLastSong = -1;
            this.randomFloat = this.random.method_43057();
            musicInstance = this.currentMusicPlaying = class_1109.method_4759((class_3414)((class_3414)type.method_27279().comp_349()));
            client.method_1483().method_4873(this.currentMusicPlaying);
        }

        public void stop(class_5195 type) {
            if (this.isPlayingType(type)) {
                this.stop();
            }
        }

        public void stop() {
            if (this.currentMusicPlaying == null) {
                return;
            }
            client.method_1483().method_4870(this.currentMusicPlaying);
        }

        public boolean isPlayingType(class_5195 musicSound) {
            if (this.currentMusicPlaying == null) {
                return false;
            }
            return ((class_3414)musicSound.method_27279().comp_349()).method_14833().equals((Object)this.currentMusicPlaying.method_4775());
        }

        public void hasJoinedWorld() {
            this.hasJoinedWorld = true;
        }

        public void shouldDoFullTick() {
            this.evaluatedTickCondition = null;
        }

        private boolean isDiscMusicBlocking() {
            return InfiniteMusic.CONFIG.pauseForDiscMusic && InfiniteMusic.isMusicDiscMusicPlaying();
        }

        private class TickCondition {
            public final class_5195 musicSoundType;

            TickCondition(class_5195 musicSoundType) {
                this.musicSoundType = musicSoundType;
            }

            public boolean tick() {
                return false;
            }
        }
    }
}

